/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.instrument.JIInliner;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIMethodMergeAdapter;
import jdk.jfr.internal.instrument.JITypeMapping;

@Deprecated
final class JIClassInstrumentation {
    private final Class<?> instrumentor;
    private final String targetName;
    private final String instrumentorName;
    private final byte[] newBytes;
    private final ClassReader targetClassReader;
    private final ClassReader instrClassReader;

    JIClassInstrumentation(Class<?> clazz, Class<?> clazz2, byte[] byArray) throws ClassNotFoundException, IOException {
        this.instrumentorName = clazz.getName();
        this.targetName = clazz2.getName();
        this.instrumentor = clazz;
        this.targetClassReader = new ClassReader(byArray);
        this.instrClassReader = new ClassReader(JIClassInstrumentation.getOriginalClassBytes(clazz));
        this.newBytes = this.makeBytecode();
        Utils.writeGeneratedASM(clazz2.getName(), this.newBytes);
    }

    private static byte[] getOriginalClassBytes(Class<?> clazz) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = "/" + clazz.getName().replace(".", "/") + ".class";
        InputStream inputStream = SecuritySupport.getResourceAsStream(string);
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] makeBytecode() throws IOException, ClassNotFoundException {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : this.instrumentor.getDeclaredMethods()) {
            JIInstrumentationMethod jIInstrumentationMethod = method.getAnnotation(JIInstrumentationMethod.class);
            if (jIInstrumentationMethod == null) continue;
            arrayList.add(method);
        }
        ClassNode classNode = new ClassNode();
        JIInliner jIInliner = new JIInliner(327680, classNode, this.targetName, this.instrumentorName, this.targetClassReader, arrayList);
        this.instrClassReader.accept(jIInliner, 8);
        ClassWriter classWriter = new ClassWriter(2);
        JIMethodMergeAdapter jIMethodMergeAdapter = new JIMethodMergeAdapter(classWriter, classNode, arrayList, (JITypeMapping[])this.instrumentor.getAnnotationsByType(JITypeMapping.class));
        this.targetClassReader.accept(jIMethodMergeAdapter, 8);
        return classWriter.toByteArray();
    }

    public byte[] getNewBytes() {
        return (byte[])this.newBytes.clone();
    }
}

