/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.HighlighterPipeline;

public class JXTree
extends JTree {
    private Method conversionMethod = null;
    private static final Class[] methodSignature = new Class[]{Object.class};
    private static final Object[] methodArgs = new Object[]{null};
    protected FilterPipeline filters;
    protected HighlighterPipeline highlighters;
    private ChangeListener highlighterChangeListener;
    private DelegatingRenderer delegatingRenderer;
    private RolloverProducer rolloverProducer;
    private LinkController linkController;
    private boolean overwriteIcons;
    private Searchable searchable;
    private final ComponentAdapter dataAdapter = new TreeAdapter(this);

    public JXTree() {
        this.initActions();
    }

    public JXTree(Object[] objectArray) {
        super(objectArray);
        this.initActions();
    }

    public JXTree(Vector vector) {
        super(vector);
        this.initActions();
    }

    public JXTree(Hashtable hashtable) {
        super(hashtable);
        this.initActions();
    }

    public JXTree(TreeNode treeNode) {
        super(treeNode, false);
    }

    public JXTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.initActions();
    }

    public JXTree(TreeModel treeModel) {
        super(treeModel);
        this.initActions();
        this.conversionMethod = this.getValueConversionMethod(treeModel);
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.conversionMethod = this.getValueConversionMethod(treeModel);
    }

    private Method getValueConversionMethod(TreeModel treeModel) {
        try {
            return treeModel == null ? null : treeModel.getClass().getMethod("convertValueToText", methodSignature);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object != null) {
            if (this.conversionMethod == null) {
                return object.toString();
            }
            try {
                JXTree.methodArgs[0] = object;
                return (String)this.conversionMethod.invoke((Object)this.getModel(), methodArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("expand-all", new Actions("expand-all"));
        actionMap.put("collapse-all", new Actions("collapse-all"));
        actionMap.put("find", this.createFindAction());
        KeyStroke keyStroke = KeyStroke.getKeyStroke("control F");
        this.getInputMap(1).put(keyStroke, "find");
    }

    private Action createFindAction() {
        UIAction uIAction = new UIAction("find"){

            public void actionPerformed(ActionEvent actionEvent) {
                JXTree.this.doFind();
            }
        };
        return uIAction;
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TreeSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline highlighterPipeline) {
        HighlighterPipeline highlighterPipeline2 = this.getHighlighters();
        if (highlighterPipeline2 != null) {
            highlighterPipeline2.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters = highlighterPipeline;
        if (this.highlighters != null) {
            this.highlighters.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", highlighterPipeline2, this.getHighlighters());
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JXTree.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.isRolloverEnabled();
        if (bl == bl2) {
            return;
        }
        if (bl) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.linkController = new LinkController();
            this.addPropertyChangeListener(this.linkController);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.removePropertyChangeListener(this.linkController);
            this.linkController = null;
        }
        this.firePropertyChange("rolloverEnabled", bl2, this.isRolloverEnabled());
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer rolloverProducer = new RolloverProducer(){

            public void mousePressed(MouseEvent mouseEvent) {
                JXTree jXTree = (JXTree)mouseEvent.getComponent();
                Point point = mouseEvent.getPoint();
                int n = jXTree.getRowForLocation(point.x, point.y);
                if (n >= 0) {
                    return;
                }
                int n2 = jXTree.getClosestRowForLocation(point.x, point.y);
                Rectangle rectangle = jXTree.getRowBounds(n2);
                if (rectangle == null) {
                    n2 = -1;
                } else if (rectangle.y + rectangle.height < point.y || rectangle.x > point.x) {
                    n2 = -1;
                }
                if (n2 < 0) {
                    return;
                }
                jXTree.dispatchEvent(new MouseEvent(jXTree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), rectangle.x + rectangle.width - 2, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            }

            protected void updateRolloverPoint(JComponent jComponent, Point point) {
                int n;
                JXTree jXTree = (JXTree)jComponent;
                int n2 = jXTree.getClosestRowForLocation(point.x, point.y);
                Rectangle rectangle = jXTree.getRowBounds(n2);
                if (rectangle == null) {
                    n2 = -1;
                } else if (rectangle.y + rectangle.height < point.y || rectangle.x > point.x) {
                    n2 = -1;
                }
                this.rollover.x = n = n2 < 0 ? -1 : 0;
                this.rollover.y = n2;
            }
        };
        return rolloverProducer;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
            this.delegatingRenderer.setDelegateRenderer(super.getCellRenderer());
        }
        return this.delegatingRenderer;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.getDelegatingRenderer().setDelegateRenderer(treeCellRenderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    public void setExpandedIcon(Icon icon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(icon);
        }
    }

    public void setCollapsedIcon(Icon icon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(icon);
        }
    }

    public void setLeafIcon(Icon icon) {
        this.getDelegatingRenderer().setLeafIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.getDelegatingRenderer().setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.getDelegatingRenderer().setClosedIcon(icon);
    }

    public void setOverwriteRendererIcons(boolean bl) {
        if (this.overwriteIcons == bl) {
            return;
        }
        boolean bl2 = this.overwriteIcons;
        this.overwriteIcons = bl;
        this.firePropertyChange("overwriteRendererIcons", bl2, bl);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    protected ComponentAdapter getComponentAdapter() {
        return this.dataAdapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree jXTree) {
            super(jXTree);
            this.tree = jXTree;
        }

        public JXTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int n, int n2) {
            TreePath treePath = this.tree.getPathForRow(n);
            return treePath.getLastPathComponent();
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.getValueAt(n, n2);
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public String getColumnName(int n) {
            return "Column_" + n;
        }

        public String getColumnIdentifier(int n) {
            return null;
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this.initIcons(new DefaultTreeCellRenderer());
        }

        private void initIcons(DefaultTreeCellRenderer defaultTreeCellRenderer) {
            this.closedIcon = defaultTreeCellRenderer.getDefaultClosedIcon();
            this.openIcon = defaultTreeCellRenderer.getDefaultOpenIcon();
            this.leafIcon = defaultTreeCellRenderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer treeCellRenderer) {
            if (treeCellRenderer == null) {
                treeCellRenderer = new DefaultTreeCellRenderer();
            }
            this.delegate = treeCellRenderer;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(icon);
            }
            this.closedIcon = icon;
        }

        public void setOpenIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(icon);
            }
            this.openIcon = icon;
        }

        public void setLeafIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(icon);
            }
            this.leafIcon = icon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = this.delegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (JXTree.this.highlighters != null) {
                JXTree.this.getComponentAdapter().row = n;
                component = JXTree.this.highlighters.apply(component, JXTree.this.getComponentAdapter());
            }
            return component;
        }
    }

    public class LinkController
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("swingx.rollover".equals(propertyChangeEvent.getPropertyName())) {
                this.rollover((JXTree)propertyChangeEvent.getSource(), (Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getOldValue());
            }
        }

        private void rollover(JXTree jXTree, Point point, Point point2) {
            jXTree.repaint();
        }
    }

    public class TreeSearchable
    extends AbstractSearchable {
        protected void findMatchAndUpdateState(Pattern pattern, int n, boolean bl) {
            AbstractSearchable.SearchResult searchResult = null;
            if (bl) {
                for (int i = n; i >= 0 && searchResult == null; --i) {
                    searchResult = this.findMatchAt(pattern, i);
                }
            } else {
                for (int i = n; i < this.getSize() && searchResult == null; ++i) {
                    searchResult = this.findMatchAt(pattern, i);
                }
            }
            this.updateState(searchResult);
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int n) {
            return this.findMatchAt(pattern, n);
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int n) {
            Matcher matcher;
            TreePath treePath = JXTree.this.getPathForRow(n);
            Object object = null;
            if (treePath != null) {
                object = treePath.getLastPathComponent();
            }
            if (object != null && (matcher = pattern.matcher(object.toString())).find()) {
                return this.createSearchResult(matcher, n, -1);
            }
            return null;
        }

        protected int getSize() {
            return JXTree.this.getRowCount();
        }

        protected void moveMatchMarker() {
            int n = this.lastSearchResult.foundRow;
            JXTree.this.setSelectionRow(n);
            if (n >= 0) {
                JXTree.this.scrollRowToVisible(n);
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("expand-all".equals(this.getName())) {
                JXTree.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTree.this.collapseAll();
            }
        }
    }
}

