/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jdesktop.swingx.event.MessageEvent;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.ProgressEvent;
import org.jdesktop.swingx.event.ProgressListener;

public class JXStatusBar
extends JPanel
implements MessageListener,
ProgressListener {
    private JLabel leadingLabel;
    private JLabel trailingLabel;
    private JProgressBar progressBar;
    private Dimension preferredSize;

    public JXStatusBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.leadingLabel = (JLabel)this.add(new JLabel("", 10));
        this.add(Box.createHorizontalGlue());
        this.progressBar = (JProgressBar)this.add(new JProgressBar());
        this.progressBar.setVisible(false);
        this.trailingLabel = (JLabel)this.add(new JLabel("", 11));
        Font font = this.leadingLabel.getFont().deriveFont(0);
        this.leadingLabel.setFont(font);
        this.trailingLabel.setFont(font);
        this.setFont(font);
        this.preferredSize = new Dimension(this.getWidth("    "), 2 * this.getFontHeight());
    }

    public void setText(String string) {
        this.setLeadingMessage(string);
    }

    public String getText() {
        return this.getLeadingMessage();
    }

    public void setLeadingMessage(String string) {
        this.leadingLabel.setText(string);
    }

    public String getLeadingMessage() {
        return this.leadingLabel.getText();
    }

    public void setTrailingMessage(String string) {
        this.trailingLabel.setText(string);
    }

    public String getTrailingMessage() {
        return this.trailingLabel.getText();
    }

    protected int getWidth(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return 0;
        }
        return fontMetrics.stringWidth(string);
    }

    protected int getFontHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return 0;
        }
        return fontMetrics.getHeight();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void message(MessageEvent messageEvent) {
        Level level = messageEvent.getLevel();
        if (level == Level.FINE) {
            this.setLeadingMessage(messageEvent.getMessage());
        } else {
            this.setTrailingMessage(messageEvent.getMessage());
        }
    }

    public void progressStarted(ProgressEvent progressEvent) {
        boolean bl = progressEvent.isIndeterminate();
        this.progressBar.setIndeterminate(bl);
        if (!bl) {
            this.progressBar.setValue(progressEvent.getMinimum());
            this.progressBar.setMinimum(progressEvent.getMinimum());
            this.progressBar.setMaximum(progressEvent.getMaximum());
        }
        this.progressBar.setVisible(true);
    }

    public void progressIncremented(ProgressEvent progressEvent) {
        this.progressBar.setValue(progressEvent.getProgress());
    }

    public void progressEnded(ProgressEvent progressEvent) {
        this.progressBar.setVisible(false);
    }
}

