/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.geojson.GeoJSONDataStore;
import org.geotools.data.geojson.GeoJSONFeatureReader;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoJSONFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)GeoJSONFeatureWriter.class.getName());
    private ContentState state;
    private File temp;
    private GeoJSONWriter geoJSONWriter;
    private GeoJSONFeatureReader delegate;
    private SimpleFeature currentFeature;
    private boolean appending = false;
    private int nextID = 0;
    private File file;

    public GeoJSONFeatureWriter(ContentState state, Query query) throws IOException {
        this.state = state;
        String typeName = query.getTypeName();
        URL url = ((GeoJSONDataStore)state.getEntry().getDataStore()).url;
        this.file = URLs.urlToFile((URL)url);
        File directory = this.file.getParentFile();
        LOGGER.fine("Opening writer for " + url);
        if (directory == null) {
            throw new IOException("Unable to find parent direcotry of file " + this.file + " from url " + url);
        }
        if (!directory.canWrite()) {
            throw new IOException("Directory " + directory + " is not writable.");
        }
        this.temp = File.createTempFile(typeName + System.currentTimeMillis(), "geojson", directory);
        LOGGER.fine("Writing to " + this.temp.getAbsolutePath());
        this.geoJSONWriter = new GeoJSONWriter(new FileOutputStream(this.temp));
        this.delegate = new GeoJSONFeatureReader(state, query);
    }

    public SimpleFeatureType getFeatureType() {
        return this.delegate.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.geoJSONWriter == null) {
            throw new IOException("Writer is closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        try {
            if (!this.appending) {
                if (this.delegate.reader != null && this.delegate.hasNext()) {
                    this.currentFeature = this.delegate.next();
                    return this.currentFeature;
                }
                this.appending = true;
            }
            SimpleFeatureType featureType = this.state.getFeatureType();
            String fid = featureType.getTypeName() + "." + this.nextID;
            Object[] values = DataUtilities.defaultValues((SimpleFeatureType)featureType);
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])values, (String)fid);
            return this.currentFeature;
        }
        catch (IllegalArgumentException invalid) {
            throw new IOException("Unable to create feature:" + invalid.getMessage(), invalid);
        }
    }

    public boolean hasNext() throws IOException {
        if (this.geoJSONWriter == null) {
            return false;
        }
        if (this.appending) {
            return false;
        }
        return this.delegate.hasNext();
    }

    public void close() throws IOException {
        LOGGER.entering(this.getClass().getName(), "close");
        if (this.geoJSONWriter == null) {
            throw new IOException("Writer is already closed");
        }
        if (this.currentFeature != null) {
            LOGGER.fine("Writing current feature");
            this.write();
        }
        while (this.hasNext()) {
            LOGGER.fine("writing remaining features");
            this.next();
            this.write();
        }
        this.geoJSONWriter.close();
        this.geoJSONWriter = null;
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
        LOGGER.fine("Copyting " + this.temp + " to " + this.file);
        Files.copy(this.temp.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void remove() throws IOException {
        LOGGER.fine("deleting current feature (" + this.currentFeature.getID() + ")");
        this.currentFeature = null;
    }

    public void write() throws IOException {
        if (this.currentFeature == null) {
            return;
        }
        LOGGER.fine("writing current feature (" + this.currentFeature.getID() + ")");
        this.geoJSONWriter.write(this.currentFeature);
        ++this.nextID;
        this.currentFeature = null;
    }
}

