/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;

public class DlgUnconvertableBankData
extends JDialog {
    private static final long serialVersionUID = 5674232044360617700L;
    private JTable tblResults;
    private DefaultTableModel dtm;
    private JLabel lblDesc;
    private ResourceBundle localProperty;

    public DlgUnconvertableBankData() {
        this.setModal(true);
        this.setResizable(false);
        this.setSize(new Dimension(640, 480));
        this.setLocationRelativeTo(PSO.mainpanel);
        this.localProperty = ResourceBundle.getBundle("properties.DlgUnconvertableBankData", PSUser.getLanguage());
        this.setTitle(this.localProperty.getString("dlgTitle"));
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BorderLayout());
        this.lblDesc = new JLabel(this.localProperty.getString("lblDescErr"));
        searchPanel.add((Component)this.lblDesc, "North");
        searchPanel.add(Box.createVerticalStrut(20));
        Vector<String> headers = new Vector<String>();
        headers.add("Kundennummer");
        headers.add("Firma/Name");
        headers.add("Konvertierung");
        headers.add("Fehlermeldung");
        this.dtm = new DefaultTableModel(){
            private static final long serialVersionUID = 1010476947563076491L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.dtm.setColumnIdentifiers(headers);
        this.tblResults = new JTable(this.dtm);
        this.tblResults.setPreferredSize(new Dimension(600, 350));
        this.tblResults.setRowHeight(50);
        this.tblResults.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.tblResults.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.tblResults.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.tblResults.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.tblResults.getColumnModel().getColumn(0).setCellRenderer(new SepaTableCellRenderer());
        this.tblResults.getColumnModel().getColumn(1).setCellRenderer(new SepaTableCellRenderer());
        this.tblResults.getColumnModel().getColumn(2).setCellRenderer(new SepaTableCellRenderer());
        this.tblResults.getColumnModel().getColumn(3).setCellRenderer(new SepaTableCellRenderer());
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.setViewportView(this.tblResults);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(1));
        JButton btnOk = new JButton(this.localProperty.getString("btnOk"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgUnconvertableBankData.this.dispose();
            }
        });
        btnPanel.add(btnOk);
        this.getContentPane().add((Component)searchPanel, "North");
        this.getContentPane().add((Component)tableScrollPane, "Center");
        this.getContentPane().add((Component)btnPanel, "South");
    }

    public void setResponse(String data) {
        if (data.length() > 0) {
            String[] rows = data.split("\\|");
            int i = 0;
            while (i < rows.length) {
                Object[] rowData = rows[i].split(";");
                rowData[3] = "<html>" + PSEnvironment.insertUmlaute(rowData[3]) + "</html>";
                this.dtm.addRow(rowData);
                ++i;
            }
        } else {
            this.lblDesc.setText(this.localProperty.getString("lblDescNoErr"));
        }
    }

    private class SepaTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private SepaTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value.toString());
            this.setOpaque(true);
            if (table.getColumnModel().getColumn(column).getWidth() < this.getPreferredSize().width) {
                this.setToolTipText(value.toString());
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

