/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PamDialog;
import prospektservice.base.pwstrength.PasswordStrengthCalculator;
import prospektservice.base.pwstrength.TStrengthIndicator;

public class DlgChangePassword
extends PamDialog {
    private static final long serialVersionUID = 3905519419273982773L;
    private static final int WIDTH = 270;
    private static final int HEIGHT = 170;
    private JPanel editPanel;
    private JPanel btnPanel;
    private JLabel lblOldPW;
    private JLabel lblNewPW;
    private JLabel lblConfirmPW;
    private JPasswordField txtOldPW;
    private JPasswordField txtNewPW;
    private JPasswordField txtConfirmPW;
    private JButton btnCancel;
    private JButton btnOk;
    private ResourceBundle localProperty = ResourceBundle.getBundle("properties.DlgChangePassword", PSEnvironment.getEnvironmentLanguage());
    private TStrengthIndicator strengthIndicator;
    private boolean dissallowCancel;

    public DlgChangePassword(Frame regform) throws HeadlessException {
        super(regform);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(270, 170);
        this.setLocation((d.width - 270) / 2, (d.height - 170) / 2);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(this.localProperty.getString("Title"));
        this.getContentPane().setLayout(new BorderLayout());
        this.editPanel = new JPanel();
        GridLayout gl = new GridLayout(4, 2);
        gl.setHgap(10);
        gl.setVgap(10);
        this.editPanel.setLayout(gl);
        this.lblOldPW = new JLabel(this.localProperty.getString("lblOldPass"));
        this.lblOldPW.setHorizontalAlignment(4);
        this.editPanel.add(this.lblOldPW);
        this.txtOldPW = new JPasswordField();
        this.txtOldPW.setPreferredSize(new Dimension(200, 20));
        this.editPanel.add(this.txtOldPW);
        this.lblNewPW = new JLabel(this.localProperty.getString("lblNewPass"));
        this.lblNewPW.setHorizontalAlignment(4);
        this.editPanel.add(this.lblNewPW);
        this.txtNewPW = new JPasswordField();
        this.txtNewPW.setPreferredSize(new Dimension(200, 20));
        this.editPanel.add(this.txtNewPW);
        this.lblConfirmPW = new JLabel(this.localProperty.getString("lblConfirmPass"));
        this.lblConfirmPW.setHorizontalAlignment(4);
        this.editPanel.add(this.lblConfirmPW);
        this.txtConfirmPW = new JPasswordField();
        this.txtConfirmPW.setPreferredSize(new Dimension(200, 20));
        this.editPanel.add(this.txtConfirmPW);
        JLabel lblPwStrength = new JLabel(this.localProperty.getString("lblPwStrength"));
        lblPwStrength.setHorizontalAlignment(4);
        this.editPanel.add(lblPwStrength);
        this.strengthIndicator = new TStrengthIndicator();
        this.strengthIndicator.setMinimumValue(0);
        this.strengthIndicator.setMaximumValue(3);
        this.strengthIndicator.setFont(this.lblOldPW.getFont());
        this.strengthIndicator.setBorder(new LineBorder(Color.BLACK));
        this.editPanel.add(this.strengthIndicator);
        this.getContentPane().add((Component)this.editPanel, "North");
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(2));
        this.btnCancel = new JButton(this.localProperty.getString("btnCancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgChangePassword.this.dissallowCancel) {
                    if (JOptionPane.showConfirmDialog(null, DlgChangePassword.this.localProperty.getString("MsgForcedCancel"), DlgChangePassword.this.localProperty.getString("MsgForcedCancelTitle"), 0) == 0) {
                        DlgChangePassword.this.dispose();
                        PSO.mainpanel.dispose(true);
                    }
                } else {
                    DlgChangePassword.this.dispose();
                }
            }
        });
        this.btnPanel.add(this.btnCancel);
        this.btnOk = new JButton(this.localProperty.getString("btnOk"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PSEnvironment.isSecurePassword(new String(DlgChangePassword.this.txtNewPW.getPassword()))) {
                    if (new String(DlgChangePassword.this.txtNewPW.getPassword()).trim().length() == 0 || new String(DlgChangePassword.this.txtConfirmPW.getPassword()).trim().length() == 0) {
                        JOptionPane.showMessageDialog(null, DlgChangePassword.this.localProperty.getString("MsgFailureC"));
                    } else if (new String(DlgChangePassword.this.txtNewPW.getPassword()).equals(new String(DlgChangePassword.this.txtConfirmPW.getPassword()))) {
                        PSO.cc.SendMessage(334, String.valueOf(new String(DlgChangePassword.this.txtOldPW.getPassword())) + "|" + new String(DlgChangePassword.this.txtNewPW.getPassword()));
                    } else {
                        JOptionPane.showMessageDialog(null, DlgChangePassword.this.localProperty.getString("MsgFailureA"));
                    }
                } else {
                    JOptionPane.showMessageDialog(null, DlgChangePassword.this.localProperty.getString("MsgWeakPW"));
                }
            }
        });
        this.btnPanel.add(this.btnOk);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.getRootPane().setDefaultButton(this.btnOk);
        DocumentListener docHandler = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DlgChangePassword.this.handleDocumentUpdate(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DlgChangePassword.this.handleDocumentUpdate(e.getDocument());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DlgChangePassword.this.handleDocumentUpdate(e.getDocument());
            }
        };
        this.txtNewPW.getDocument().addDocumentListener(docHandler);
    }

    public void yoChangePassword(String data) {
        String msg = "";
        boolean success = false;
        if (data.equals("1")) {
            msg = this.localProperty.getString("MsgSuccess");
            success = true;
        } else {
            msg = this.localProperty.getString("MsgFailureB");
        }
        JOptionPane.showMessageDialog(null, msg);
        if (success) {
            PSUser.setNeedsPwChange(false);
            this.dispose();
        }
    }

    public void handleDocumentUpdate(Document doc) {
        try {
            String text = doc.getText(0, doc.getLength());
            if (text.length() > 0) {
                int strength = PasswordStrengthCalculator.calcPwStrength(text);
                this.strengthIndicator.setValue(strength);
                if (strength > 3) {
                    strength = 3;
                }
                this.strengthIndicator.setText(this.localProperty.getString("StrengthMessage" + strength));
            } else {
                this.strengthIndicator.setText("");
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    public boolean isDissallowCancel() {
        return this.dissallowCancel;
    }

    public void setDissallowCancel(boolean dissallowCancel) {
        this.dissallowCancel = dissallowCancel;
        if (dissallowCancel) {
            this.setDefaultCloseOperation(0);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
    }
}

