/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.datamodels;

import java.awt.Color;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import prospektservice.PSEnvironment;

public class PsoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3257846588767615030L;
    protected Document workDoc = null;
    protected Document cachDoc = null;
    public static final int WORK_DOC = 0;
    public static final int CACH_DOC = 1;
    protected int BLOCK_SIZE = 40;
    protected static final int SORT_ASC = 0;
    protected static final int SORT_DESC = 1;
    protected int maxRecords = 0;
    protected int sortColumn = 0;
    protected int sortDirection = 1;
    protected String[] columnHeaders = new String[0];
    protected DefaultTableCellRenderer[] columnRenderer;
    protected String[] columnDbHeaders = new String[0];
    protected int[] lastFetchedRow = new int[]{-1, -1};
    protected int lastRowIndex = 0;
    public static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.DOMParser";
    public static final String DEFAULT_DOC_TYPE = "psodialog";
    public static String ROOT_ELEMENT_TAG = "psodaten";
    public static String ELEMENT_IN_ROOT_TAG = "ElementOfpsodaten";
    private int columnCount = 0;
    private int firstRowIndexInCachDoc = -1;
    private int firstRowIndexInWorkDoc = -1;
    private int gefetchtRowsInWorkDoc = 0;
    private int gefetchtRowsInCachDoc = 0;
    private int selectedRow = -1;

    public void setData(Document dataDoc) {
        try {
            this.cachDoc = this.workDoc;
            this.gefetchtRowsInCachDoc = this.gefetchtRowsInWorkDoc;
            this.firstRowIndexInCachDoc = this.firstRowIndexInWorkDoc;
            this.workDoc = dataDoc;
            String atributName = "currentrow";
            Element ourElement = this.workDoc.getDocumentElement();
            String currentRowOf = ourElement.getAttribute(atributName);
            if (currentRowOf != null) {
                this.firstRowIndexInWorkDoc = PSEnvironment.getIntValue(currentRowOf) - 1;
            }
            NodeList rows = this.workDoc.getDocumentElement().getElementsByTagName(ELEMENT_IN_ROOT_TAG);
            this.gefetchtRowsInWorkDoc = rows.getLength();
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
        }
    }

    @Override
    public Object getValueAt(int r, int c) {
        String currValue;
        block6: {
            currValue = "c/f";
            try {
                if (this.isRowInDocument(0, r) && this.workDoc != null) {
                    NodeList rows = this.workDoc.getDocumentElement().getElementsByTagName(ELEMENT_IN_ROOT_TAG);
                    Element row = (Element)rows.item(r -= this.firstRowIndexInWorkDoc);
                    if (c < this.columnDbHeaders.length) {
                        currValue = row.getAttribute(this.columnDbHeaders[c]);
                        break block6;
                    }
                    throw new ArrayIndexOutOfBoundsException("column was " + c);
                }
                if (!this.isRowInDocument(1, r) || this.cachDoc == null) break block6;
                NodeList rows = this.cachDoc.getDocumentElement().getElementsByTagName(ELEMENT_IN_ROOT_TAG);
                Element row = (Element)rows.item(r -= this.firstRowIndexInCachDoc);
                if (c < this.columnDbHeaders.length) {
                    currValue = row.getAttribute(this.columnDbHeaders[c]);
                    break block6;
                }
                throw new ArrayIndexOutOfBoundsException("column was " + c);
            }
            catch (Exception Ex) {
                if (PSEnvironment.DEBUG) {
                    System.out.println(Ex.getMessage());
                }
                if (!PSEnvironment.DEBUG) break block6;
                System.out.println(Ex.toString());
            }
        }
        return currValue;
    }

    public Object getValueAt(int rowIndex, String colHeaderName) {
        String currValue;
        block8: {
            currValue = "c/f";
            int c = 0;
            int j = 0;
            while (j < this.columnHeaders.length) {
                if (this.columnHeaders[j].equals(colHeaderName)) {
                    c = j;
                    break;
                }
                ++j;
            }
            try {
                if (this.isRowInDocument(0, rowIndex) && this.workDoc != null) {
                    NodeList rows = this.workDoc.getDocumentElement().getElementsByTagName(ELEMENT_IN_ROOT_TAG);
                    Element row = (Element)rows.item(rowIndex -= this.firstRowIndexInWorkDoc);
                    if (c < this.columnDbHeaders.length) {
                        currValue = row.getAttribute(this.columnDbHeaders[c]);
                        break block8;
                    }
                    throw new ArrayIndexOutOfBoundsException("column was " + c);
                }
                if (!this.isRowInDocument(1, rowIndex) || this.cachDoc == null) break block8;
                NodeList rows = this.cachDoc.getDocumentElement().getElementsByTagName(ELEMENT_IN_ROOT_TAG);
                Element row = (Element)rows.item(rowIndex -= this.firstRowIndexInCachDoc);
                if (c < this.columnDbHeaders.length) {
                    currValue = row.getAttribute(this.columnDbHeaders[c]);
                    break block8;
                }
                throw new ArrayIndexOutOfBoundsException("column was " + c);
            }
            catch (Exception Ex) {
                if (PSEnvironment.DEBUG) {
                    System.out.println(Ex.getMessage());
                }
                if (!PSEnvironment.DEBUG) break block8;
                System.out.println(Ex.toString());
            }
        }
        return currValue;
    }

    public Class<String> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
    }

    @Override
    public int getColumnCount() {
        return this.columnHeaders.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnHeaders[column];
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public int getRowCount() {
        return this.maxRecords;
    }

    public int getFirstDataIndex(int docType) {
        if (docType == 0) {
            return this.firstRowIndexInWorkDoc;
        }
        return this.firstRowIndexInCachDoc;
    }

    public int getLastDataIndex(int docType) {
        if (docType == 0) {
            return this.firstRowIndexInWorkDoc + this.gefetchtRowsInWorkDoc;
        }
        return this.firstRowIndexInCachDoc + this.gefetchtRowsInCachDoc;
    }

    public void setSortColumn(int column, int direction) {
        this.sortColumn = column;
        this.sortDirection = direction;
    }

    public void setSortColumn(int column) {
        if (this.sortColumn == column) {
            this.sortDirection = this.sortDirection == 0 ? 1 : 0;
        } else {
            this.sortColumn = column;
            this.sortDirection = 1;
        }
    }

    public void setHeader(String[] value) {
        this.columnHeaders = value;
        if (value.length > 0) {
            this.columnRenderer = new DefaultTableCellRenderer[value.length];
            int i = 0;
            while (i < value.length) {
                this.columnRenderer[i] = new DefaultTableCellRenderer();
                this.columnRenderer[i].setHorizontalAlignment(0);
                this.columnRenderer[i].setBackground(Color.white);
                ++i;
            }
        }
    }

    public void setCellRendererValues(String[] columnRendererValues) {
        int colCount = columnRendererValues.length;
        int i = 0;
        while (i < colCount) {
            int horAligment = 0;
            if (columnRendererValues[i].trim().toUpperCase().equals("LEFT")) {
                horAligment = 2;
            }
            if (columnRendererValues[i].trim().toUpperCase().equals("RIGHT")) {
                horAligment = 4;
            }
            this.columnRenderer[i].setHorizontalAlignment(horAligment);
            ++i;
        }
    }

    public DefaultTableCellRenderer[] getTableCellRenderer() {
        return this.columnRenderer;
    }

    public void setDbHeader(String[] value) {
        this.columnDbHeaders = value;
    }

    public void setMaxRecords(int value) {
        this.resetTable();
        this.maxRecords = value;
    }

    protected boolean isRowInDocument(int docType, int row) {
        return row >= this.getFirstDataIndex(docType) && row < this.getLastDataIndex(docType);
    }

    protected void keepCache() {
        if (PSEnvironment.DEBUG) {
            System.out.println("keeping cache!!");
        }
        this.firstRowIndexInWorkDoc = this.firstRowIndexInCachDoc;
        this.gefetchtRowsInWorkDoc = this.gefetchtRowsInCachDoc;
        this.workDoc = this.cachDoc;
        this.lastFetchedRow[this.lastRowIndex == 0 ? 1 : 0] = this.firstRowIndexInWorkDoc;
    }

    public int optimizeRequest(int row) {
        int result = row;
        if (!this.hasData()) {
            result = row;
        } else if (!this.isRowInDocument(1, row) && !this.isRowInDocument(0, row)) {
            if (row < this.getFirstDataIndex(0) && row >= this.getFirstDataIndex(0) - this.gefetchtRowsInWorkDoc) {
                int rowToGet = this.getFirstDataIndex(0) - this.gefetchtRowsInWorkDoc;
                result = rowToGet >= 0 ? rowToGet : 0;
            } else if (row < this.getFirstDataIndex(1) && row >= this.getFirstDataIndex(1) - this.gefetchtRowsInCachDoc) {
                this.keepCache();
                int rowToGet = this.getFirstDataIndex(1) - this.gefetchtRowsInCachDoc;
                result = rowToGet >= 0 ? rowToGet : 0;
            } else if (row >= this.getFirstDataIndex(0) + this.gefetchtRowsInWorkDoc && row < this.getFirstDataIndex(0) + this.gefetchtRowsInWorkDoc * 2) {
                result = this.getFirstDataIndex(0) + this.gefetchtRowsInWorkDoc;
            } else if (row >= this.getFirstDataIndex(1) + this.gefetchtRowsInCachDoc && row < this.getFirstDataIndex(1) + this.gefetchtRowsInCachDoc * 2) {
                this.keepCache();
                result = this.getFirstDataIndex(1) + this.gefetchtRowsInCachDoc;
            } else {
                result = row;
            }
        } else if (this.isRowInDocument(0, row)) {
            result = this.getLastDataIndex(0);
        } else if (this.isRowInDocument(1, row)) {
            this.keepCache();
            result = this.getLastDataIndex(1);
        }
        if (PSEnvironment.DEBUG) {
            System.out.println("optimized Request returning " + result);
        }
        return result;
    }

    public boolean hasData() {
        return this.workDoc != null;
    }

    public void resetTable() {
        this.workDoc = null;
        this.cachDoc = null;
        this.lastFetchedRow[0] = -1;
        this.lastFetchedRow[1] = -1;
        this.gefetchtRowsInWorkDoc = 0;
        this.gefetchtRowsInCachDoc = 0;
        this.firstRowIndexInCachDoc = -1;
        this.firstRowIndexInWorkDoc = -1;
        this.fireTableDataChanged();
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int value) {
        this.selectedRow = value;
    }
}

