/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.zbnimport;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.progress.ProgressLogger;
import prospektservice.base.zbnimport.ZbnConstants;
import prospektservice.base.zbnimport.ZbnSettings;
import prospektservice.base.zbnimport.factories.ZbnRadiusSelectorFactory;
import prospektservice.base.zbnimport.factories.zbnRadiusSelector.IZbnRadiusSelector;
import prospektservice.base.zbnimport.log.ZbnLogFileWriter;
import prospektservice.base.zbnimport.objects.VectorWrapper;
import prospektservice.base.zbnimport.objects.Zbn;
import prospektservice.dialog.DlgFilialImport;
import prospektservice.dialog.DlgZBNImportStats;

public class ZbnDataHandler
implements ZbnConstants {
    private static ZbnDataHandler instance = null;
    public static String IMPORT_SUCCESS;
    public static String IMPORT_FAILED;
    public static String periphery;
    public static String ALREADY_CONTAINED_PT1;
    public static String ALREADY_CONTAINED_PT2;
    public static String ALREADY_CONTAINED_PT3;
    public static int IMPORT_ADDZBN_COUNT;
    private static BufferedWriter circleSelFile;
    private int importCnt = 0;
    private int peripheralCnt = 0;
    private Vector<String> foundZBN = new Vector();
    private Vector<String> alreadySelectedAreas = new Vector();
    private int successfullyImported = 0;
    private int importFailed = 0;
    private int selectedRecords = 0;
    private ZbnLogFileWriter fWrite;
    private static boolean localPeripheral;
    private IZbnRadiusSelector zbnRadiusSelector = null;
    private ZbnSettings settings;
    private PSO pso = PSO.mainpanel;
    private DlgFilialImport dlgMain;
    private ResourceBundle localProperty;
    private int totalImportCnt = 0;

    static {
        IMPORT_ADDZBN_COUNT = 50;
        localPeripheral = false;
    }

    public static ZbnDataHandler getInstance(boolean recreate) {
        if (recreate || instance == null) {
            instance = new ZbnDataHandler();
        }
        return instance;
    }

    private ZbnDataHandler() {
        this.settings = new ZbnSettings();
        this.localProperty = ResourceBundle.getBundle("properties.DlgFilialImport", Locale.GERMAN);
        IMPORT_SUCCESS = this.localProperty.getString("IMPORT_SUCCESS");
        IMPORT_FAILED = this.localProperty.getString("IMPORT_FAILED");
        periphery = this.localProperty.getString("periphery");
        ALREADY_CONTAINED_PT1 = this.localProperty.getString("ALREADY_CONTAINED_PT1");
        ALREADY_CONTAINED_PT2 = this.localProperty.getString("ALREADY_CONTAINED_PT2");
        ALREADY_CONTAINED_PT3 = this.localProperty.getString("ALREADY_CONTAINED_PT3");
        this.localProperty = ResourceBundle.getBundle("properties.DlgFilialImport", PSUser.getLanguage());
    }

    public void showZbnDialog() {
        this.dlgMain = new DlgFilialImport(this.pso, this.localProperty, this.settings, this);
        this.dlgMain.setVisible(true);
    }

    public void destroy() {
        if (this.zbnRadiusSelector != null) {
            this.zbnRadiusSelector.destroy();
        }
        this.foundZBN.removeAllElements();
        this.alreadySelectedAreas.removeAllElements();
    }

    public void doAdd(boolean isPeripheral) {
        this.doAdd(isPeripheral, 0, this.settings.getMaxRadiusHH());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(boolean isPeripheral, int hh, int optHH) {
        localPeripheral = isPeripheral;
        String srcID = "";
        String orgZbn = "";
        Vector<String> peripheralZb = new Vector<String>();
        try {
            Vector<String> vector = this.foundZBN;
            synchronized (vector) {
                int i = 0;
                while (i < this.foundZBN.size()) {
                    block33: {
                        if (this.settings.isImportCanceled()) break;
                        orgZbn = this.foundZBN.elementAt(i).toString();
                        if (this.settings.isUseItemID() && !localPeripheral) {
                            StringTokenizer t = new StringTokenizer(orgZbn, "+");
                            String tmpZb = t.nextToken();
                            if (t.hasMoreTokens()) {
                                srcID = t.nextToken();
                            }
                            orgZbn = tmpZb;
                        }
                        if (!this.alreadySelectedAreas.contains(orgZbn) && !localPeripheral) {
                            Enumeration<Zbn> selZBN;
                            try {
                                VectorWrapper vectorWrapper = new VectorWrapper();
                                vectorWrapper.addVector(this.foundZBN);
                                vectorWrapper.addVector(this.alreadySelectedAreas);
                                vectorWrapper.addVector(peripheralZb);
                                if (this.settings.getMaxRadiusHH() > 0) {
                                    if (PSEnvironment.DEBUG) {
                                        System.out.println("Selected Radius Calculator");
                                    }
                                    selZBN = this.zbnRadiusSelector.getZbn(vectorWrapper, orgZbn, hh, this.settings.getUmkreisContent(), optHH, this.pso.AE.postwurfan, this.settings.getOptimizeMode() + 1);
                                } else {
                                    if (PSEnvironment.DEBUG) {
                                        System.out.println("Selected normal");
                                    }
                                    selZBN = this.zbnRadiusSelector.getZbn(orgZbn, this.settings.getUmkreisContent());
                                }
                            }
                            catch (IllegalArgumentException iaEx) {
                                PSEnvironment.printDebugMessage("DlgFilialImport.doAdd()", String.valueOf(orgZbn) + " -> nicht in Karte vorhanden!");
                                break block33;
                            }
                            String tmp = "";
                            String toAdd = "";
                            if (selZBN != null) {
                                while (selZBN.hasMoreElements()) {
                                    tmp = selZBN.nextElement().toString();
                                    if (tmp.equals(orgZbn)) continue;
                                    if (tmp.length() < 7) {
                                        tmp = "0" + tmp;
                                    }
                                    peripheralZb.addElement(tmp);
                                    toAdd = String.valueOf(toAdd) + tmp.substring(0, 5) + "-" + tmp.substring(5, 7) + "\t";
                                }
                            }
                            if (this.settings.isImportCanceled()) break;
                            if (this.settings.isChkLogFileSelected() && this.settings.isOptFileModeSelected()) {
                                this.fWrite.writeToSecondCache(orgZbn, toAdd);
                            }
                        }
                        if (localPeripheral) {
                            peripheralZb.addElement(orgZbn);
                        }
                        this.alreadySelectedAreas.addElement(orgZbn);
                    }
                    ++i;
                }
                this.foundZBN.removeAllElements();
                if (localPeripheral) {
                    orgZbn = "";
                    this.alreadySelectedAreas.removeAllElements();
                }
                String srvZB = "";
                boolean doSendLast = false;
                int i2 = 0;
                while (i2 < peripheralZb.size()) {
                    String sendStr;
                    String zbn = ((String)peripheralZb.elementAt(i2)).toString();
                    if (!this.alreadySelectedAreas.contains(zbn) && !orgZbn.equals(zbn)) {
                        if (this.settings.isImportCanceled()) break;
                        if (this.settings.isOptFileModeSelected() && !localPeripheral) {
                            srvZB = String.valueOf(zbn.substring(0, 5)) + "-" + zbn.substring(5, zbn.length()) + (this.settings.isUseItemID() ? "+" + srcID : "");
                            circleSelFile.write(srvZB);
                            circleSelFile.newLine();
                            circleSelFile.flush();
                        } else {
                            if (this.settings.isUseItemID()) {
                                StringTokenizer t = new StringTokenizer(zbn, "+");
                                String tmpZb = t.nextToken();
                                if (t.hasMoreTokens()) {
                                    srcID = t.nextToken();
                                }
                                zbn = tmpZb;
                            }
                            srvZB = String.valueOf(srvZB) + zbn.substring(0, 5) + "-" + zbn.substring(5, zbn.length()) + (this.settings.isUseItemID() ? "+" + srcID : "") + "|";
                            if ((i2 + 1) % IMPORT_ADDZBN_COUNT == 0 || i2 == peripheralZb.size() - 1) {
                                doSendLast = peripheralZb.size() - 1 - i2 <= IMPORT_ADDZBN_COUNT;
                                sendStr = String.valueOf(doSendLast ? "1|" : "0|") + srvZB;
                                PSO.cc.SendMessage(314, sendStr);
                                srvZB = "";
                                this.addPeripheral();
                            }
                        }
                        this.alreadySelectedAreas.addElement(zbn);
                    } else if (this.settings.isOptDirectModeSelected() && i2 == peripheralZb.size() - 1 && !doSendLast) {
                        doSendLast = true;
                        sendStr = "1|" + srvZB;
                        PSO.cc.SendMessage(314, sendStr);
                        srvZB = "";
                        this.addPeripheral();
                    }
                    if (this.settings.isImportCanceled()) break;
                    ++i2;
                }
                if (!this.settings.isImportCanceled()) {
                    if (this.settings.isOptFileModeSelected() && !localPeripheral) {
                        this.addPeripheral();
                        this.addZBNDirect("-1");
                    }
                    if (this.settings.isOptDirectModeSelected() && this.settings.isChkUmkreisSelected() && peripheralZb.size() == 0) {
                        this.addPeripheral();
                        this.addZBNDirect(String.valueOf(this.selectedRecords));
                    }
                }
            }
            peripheralZb.removeAllElements();
            peripheralZb = null;
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
        }
    }

    public Vector readZBVector() {
        String line = "";
        Vector importZBVector = new Vector();
        try {
            File file = new File(String.valueOf(PSEnvironment.getPSPath()) + ZbnConstants.LOG_FILE_DIR + "zbnSelection.txt");
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while (br.ready()) {
                    Vector<String> lineVector = new Vector<String>();
                    line = br.readLine().trim();
                    if (line.length() <= 0) continue;
                    if (this.settings.isUseItemID() && this.dlgMain.getActPane() == 8) {
                        String visualLine = line.substring(0, line.indexOf("+"));
                        lineVector.addElement(visualLine);
                    } else {
                        lineVector.addElement(line);
                    }
                    this.foundZBN.addElement(PSEnvironment.formatZBN(line));
                    importZBVector.addElement(lineVector);
                }
                br.close();
                return importZBVector;
            }
            Feedback.showMessage(this.pso, 25);
            return importZBVector;
        }
        catch (Exception Ex) {
            PSEnvironment.printExceptionMessage(Ex);
            return importZBVector;
        }
    }

    public ZbnLogFileWriter getLogWriter() {
        return this.fWrite;
    }

    public void initLogFile() throws IOException {
        File logFileDir = new File(String.valueOf(PSEnvironment.getPSPath()) + LOG_FILE_DIR);
        if (!(logFileDir = new File(logFileDir.getCanonicalPath())).exists()) {
            logFileDir.mkdirs();
        }
        this.fWrite = new ZbnLogFileWriter(String.valueOf(PSEnvironment.getPSPath()) + LOG_FILE_DIR + "aoui0001", this.settings.isUseItemID(), this.settings.isChkUmkreisSelected());
        this.fWrite.setLogEntgelt(this.settings.isLogEntgelt());
        this.fWrite.write(String.valueOf(this.settings.isUseItemID() ? "ZS\t" : "") + (this.settings.isLogEntgelt() ? this.localProperty.getString("LogFileHeaderEntgelt") : this.localProperty.getString("LogFileHeader")));
        this.fWrite.newLine(this.getLineSep());
    }

    private void addToProtocol(String hhCount, String data) {
        if (data.indexOf(IMPORT_FAILED) != -1) {
            ++this.importFailed;
        } else {
            ++this.successfullyImported;
        }
        if (this.settings.isChkLogFileSelected()) {
            this.fWrite.writeToFirstCache(hhCount.trim(), data);
        }
    }

    public void finishLog() {
        this.finishLog(true);
    }

    public void finishLog(boolean showDlg) {
        try {
            this.fWrite.combineCaches();
            if (this.settings.isImportCanceled()) {
                this.fWrite.newLine(this.getLineSep());
                this.fWrite.write(this.localProperty.getString("importCanceled"));
            }
            this.fWrite.newLine(this.getLineSep());
            this.fWrite.write(this.localProperty.getString("ImportStats"));
            this.fWrite.newLine(this.getLineSep());
            this.fWrite.write(String.valueOf(this.localProperty.getString("importSuccess")) + this.successfullyImported);
            this.fWrite.newLine(this.getLineSep());
            this.fWrite.write(String.valueOf(this.localProperty.getString("importFailed")) + this.importFailed);
            this.fWrite.flushFile();
            if (showDlg) {
                new DlgZBNImportStats(this.pso, String.valueOf(LOG_FILE_DIR) + "aoui0001", this.settings.isUseItemID());
            }
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
        }
    }

    public void initCircleSelFile() throws IOException {
        File logFileDir = new File(String.valueOf(PSEnvironment.getPSPath()) + LOG_FILE_DIR);
        if (!(logFileDir = new File(logFileDir.getCanonicalPath())).exists()) {
            logFileDir.mkdirs();
        }
        circleSelFile = new BufferedWriter(new FileWriter(String.valueOf(PSEnvironment.getPSPath()) + LOG_FILE_DIR + "zbnSelection.txt"));
    }

    public void closeCircleSelFile() throws IOException {
        if (circleSelFile != null) {
            circleSelFile.flush();
            circleSelFile.close();
        }
    }

    public void addData(String tmp) {
        String records = "";
        String optHH = "0";
        boolean addData = true;
        if (PSEnvironment.MANUALL_PROGRESS) {
            ProgressLogger.increaseUnit();
        }
        --this.importCnt;
        try {
            StringTokenizer t = new StringTokenizer(tmp, "|");
            if (t.countTokens() > 1) {
                optHH = t.nextToken().trim();
                records = t.nextToken().trim();
                if (PSEnvironment.getIntValue(records) > 0) {
                    this.selectedRecords = PSEnvironment.getIntValue(records);
                }
                if (this.settings.isOptFileModeSelected()) {
                    String blub = " ";
                    String bla = "";
                    if (t.hasMoreTokens()) {
                        blub = t.nextToken();
                    }
                    if (t.hasMoreTokens()) {
                        bla = t.nextToken();
                    } else {
                        bla = blub;
                        blub = "";
                    }
                    this.addToProtocol(blub, bla);
                }
            }
            if (this.importCnt == 0) {
                if (!this.settings.isChkUmkreisSelected() && this.settings.isOptFileModeSelected()) {
                    String[] ambStr = new String[]{};
                    if (this.settings.isChkLogFileSelected()) {
                        ambStr = this.fWrite.getAmbiguousEntries();
                    }
                    if (ambStr != null) {
                        if (ambStr.length > 0) {
                            this.dlgMain.initStepAssign(ambStr);
                            this.dlgMain.progressDialogClose();
                            return;
                        }
                        this.dlgMain.progressDialogClose();
                        if (PSEnvironment.getIntValue(records) >= 0) {
                            if (this.settings.isLogEntgelt() && !this.settings.isChkUmkreisSelected()) {
                                this.fWrite.recalcHH();
                                this.totalImportCnt = PSEnvironment.getIntValue(records);
                                return;
                            }
                            this.dlgMain.closeAction(PSEnvironment.getIntValue(records));
                        } else if (this.settings.isChkLogFileSelected() && !this.settings.isChkZBFile()) {
                            this.finishLog(this.successfullyImported > 0);
                        }
                    }
                    if (this.settings.isChkSetFlagsOnlySelected()) {
                        if (PSO.workTabs.getSelectedIndex() == 1) {
                            this.pso.getUserSelection();
                        }
                        return;
                    }
                }
                if (this.settings.isOptDirectModeSelected() && !this.settings.isChkUmkreisSelected() && this.settings.getUmkreisContent() <= 0) {
                    this.dlgMain.progressDialogClose();
                    this.pso.showImportedData(this.selectedRecords);
                    this.dlgMain.dispose();
                }
                if (this.successfullyImported == 0 && this.settings.isOptFileModeSelected()) {
                    this.dlgMain.progressDialogClose();
                    this.settings.setImportCanceled(true);
                    Feedback.showMessage(this.dlgMain, 36);
                }
            }
            if (tmp.indexOf(IMPORT_FAILED) != -1 && this.settings.isOptDirectModeSelected()) {
                addData = false;
                this.dlgMain.showDirectModeError(tmp.substring(0, tmp.indexOf(IMPORT_FAILED)));
            }
            if (this.settings.isChkUmkreisSelected() && this.settings.getUmkreisContent() > 0 && addData) {
                this.addPeripheralZBs(tmp, optHH);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private synchronized void addPeripheralZBs(String zb, String optHH) {
        int hh = 0;
        try {
            if (!this.settings.isImportCanceled()) {
                if (this.settings.isOptDirectModeSelected()) {
                    this.dlgMain.createProgressDlg(this.settings.getUmkreisContent() * 120);
                }
                this.dlgMain.progressDialog.setProgressLabel(this.localProperty.getString("dlgProgress.lblProgressUmkreis"));
                if (zb.indexOf(IMPORT_FAILED) == -1) {
                    if (!this.settings.isChkSetFlagsOnlySelected()) {
                        StringTokenizer st = new StringTokenizer(zb, "|");
                        st.nextToken();
                        st.nextToken();
                        hh = PSEnvironment.getIntValue(st.nextToken().trim());
                    }
                    int pos = zb.indexOf(IMPORT_SUCCESS) + IMPORT_SUCCESS.length();
                    StringTokenizer t = new StringTokenizer(zb.substring(pos, zb.length()), "\t");
                    while (t.hasMoreTokens()) {
                        String karteZB = t.nextToken();
                        karteZB = PSEnvironment.formatZBN(karteZB);
                        if (this.settings.isImportCanceled()) break;
                        if (this.settings.isChkSetFlagsOnlySelected()) {
                            PSO.cc.SendMessage(315, karteZB.trim());
                        }
                        if (this.settings.isUseItemID()) {
                            int startPos = zb.lastIndexOf("|");
                            int endPos = zb.indexOf("\t", startPos);
                            String id = zb.substring(++startPos, endPos).trim();
                            karteZB = String.valueOf(karteZB) + "+" + id;
                        }
                        this.foundZBN.addElement(karteZB.trim());
                    }
                }
                try {
                    this.doAdd(false, hh, PSEnvironment.getIntValue(optHH));
                }
                catch (OutOfMemoryError memEx) {
                    PSEnvironment.freeMemory();
                }
            }
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
        }
    }

    public void addZBNDirect(String records) {
        this.addZBNDirect(records, false);
    }

    public void addZBNDirect(String records, boolean doIncrease) {
        if (PSEnvironment.MANUALL_PROGRESS && doIncrease) {
            ProgressLogger.increaseUnit(IMPORT_ADDZBN_COUNT);
        }
        this.removePeripheral();
        if (PSEnvironment.DEBUG) {
            System.out.println("peripheralCnt: " + this.peripheralCnt + ", importCnt: " + this.importCnt + ", foundZBN.size: " + this.foundZBN.size() + ", records: " + records);
        }
        if (records.indexOf(";") > -1 && this.settings.isChkZBFile()) {
            this.dlgMain.addZbnRecordStats(records);
            records = records.substring(0, records.indexOf(";"));
        }
        if (this.peripheralCnt == 0 && this.importCnt == 0 && this.foundZBN.size() == 0) {
            if (records.trim().equals("-1")) {
                if (this.settings.isChkUmkreisSelected()) {
                    try {
                        circleSelFile.flush();
                        circleSelFile.close();
                    }
                    catch (IOException ioex) {
                        PSEnvironment.printExceptionMessage(ioex);
                    }
                    this.dlgMain.testForReassigning();
                } else {
                    this.dlgMain.endImport(String.valueOf(this.selectedRecords));
                }
            } else {
                this.dlgMain.endImport(records);
            }
        }
    }

    public void go() {
        if (this.settings.isChkUmkreisSelected()) {
            if (this.zbnRadiusSelector == null) {
                this.zbnRadiusSelector = ZbnRadiusSelectorFactory.getZbnRadiusSelector(2);
                while (!this.zbnRadiusSelector.initialized()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.zbnRadiusSelector == null || this.zbnRadiusSelector.errorOccured()) {
                    this.settings.setChkUmkreisSelected(false);
                    return;
                }
            }
        } else if (this.zbnRadiusSelector != null) {
            this.zbnRadiusSelector.destroy();
        }
        this.dlgMain.startImport();
    }

    public void setZbnHHSum(String data) {
        this.fWrite.SetHHSum(data);
        if (this.fWrite.getHHUpdateCnt() == 0 && this.settings.isLogEntgelt() && !this.settings.isChkUmkreisSelected()) {
            this.dlgMain.closeAction(this.totalImportCnt);
        }
    }

    private String getLineSep() {
        return ZbnConstants.lineSep;
    }

    public void decrementSuccessCount() {
        --this.successfullyImported;
    }

    private int getSuccessCount() {
        return this.successfullyImported;
    }

    public void addImport() {
        ++this.importCnt;
    }

    private void removeImport() {
        --this.importCnt;
    }

    public int getImportCnt() {
        return this.importCnt;
    }

    public void addPeripheral() {
        ++this.peripheralCnt;
    }

    private void removePeripheral() {
        --this.peripheralCnt;
    }

    public int getPeripheralCnt() {
        return this.peripheralCnt;
    }

    public void clearFoundZBN() {
        this.foundZBN.removeAllElements();
    }

    public int getFoundZBNSize() {
        return this.foundZBN.size();
    }

    public int getSelectedRecords() {
        return this.selectedRecords;
    }

    public void setSelectedRecords(int selectedRecords) {
        this.selectedRecords = selectedRecords;
    }

    public void checkProgressEnd() {
        if (this.dlgMain.getActPane() == 7) {
            this.dlgMain.validate();
            this.dlgMain.repaint();
            if (!this.settings.isChkUmkreisSelected() && this.getSuccessCount() != 0 || this.settings.isChkZBFile()) {
                this.dlgMain.resetGlassPane();
                this.dlgMain.setVisible(false);
            }
        }
    }

    public void checkProgressBroken() {
        this.dlgMain.cancelAction();
        PSO.cc.resetServerCon();
        this.dlgMain.resetGlassPane();
        if (this.dlgMain.getActPane() == 7 && this.getLogWriter() != null) {
            this.getLogWriter().clearSecondCache();
        }
        this.dlgMain.progressDialogClose();
        this.dlgMain.setVisible(false);
        this.dlgMain.closeAction(-1);
    }

    public ZbnSettings getSettings() {
        return this.settings;
    }
}

