/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.pwstrength;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import prospektservice.base.pwstrength.StrengthIndicatorUI;
import prospektservice.base.pwstrength.StrengthRangeModel;

public class TStrengthIndicator
extends JComponent {
    private static final String uiClassID = "StrengthIndicatorUI";
    public static final String DATA_MODEL_PROPERTY = "StrengthIndicator.DataModel";
    private static final long serialVersionUID = 684652404780615336L;
    private StrengthRangeModel dataModel = null;
    private Handler dataModelHandler = null;
    private String text = null;

    public TStrengthIndicator() {
        this(null);
    }

    public TStrengthIndicator(StrengthRangeModel strengthRangeModel) {
        this.setDataModel(strengthRangeModel);
        this.setFocusable(false);
        this.updateUI();
    }

    public StrengthRangeModel getDataModel() {
        return this.dataModel;
    }

    public int getMaximumValue() {
        return this.dataModel.getMaxValue();
    }

    public int getMinimumValue() {
        return this.dataModel.getMinValue();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public int getValue() {
        return this.dataModel.getValue();
    }

    public void setDataModel(StrengthRangeModel dataModel) {
        if (this.dataModel == null || this.dataModel != dataModel) {
            StrengthRangeModel oldValue = this.dataModel;
            this.uninstallDataModelHandler(oldValue);
            this.dataModel = dataModel == null ? new StrengthRangeModel(0, 100, 0) : dataModel;
            this.installDataModelHandler(this.dataModel);
            this.firePropertyChange(DATA_MODEL_PROPERTY, oldValue, this.dataModel);
            this.invalidate();
            this.repaint();
        }
    }

    public void setMaximumValue(int maximumValue) {
        this.dataModel.setMaxValue(maximumValue);
    }

    public void setMinimumValue(int minimumValue) {
        this.dataModel.setMinValue(minimumValue);
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
        this.repaint();
    }

    public void setValue(int value) {
        this.dataModel.setValue(value);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(StrengthIndicatorUI.createUI(this));
        }
    }

    protected Handler getHandler() {
        if (this.dataModelHandler == null) {
            this.dataModelHandler = new Handler();
        }
        return this.dataModelHandler;
    }

    protected void installDataModelHandler(StrengthRangeModel model) {
        if (model != null) {
            model.addPropertyChangeListener(this.getHandler());
        }
    }

    protected void uninstallDataModelHandler(StrengthRangeModel model) {
        if (model != null) {
            model.removePropertyChangeListener(this.getHandler());
        }
    }

    protected class Handler
    implements PropertyChangeListener {
        protected Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == TStrengthIndicator.this.dataModel && (evt.getPropertyName() == "MaximumValueProperty" || evt.getPropertyName() == "MinimumValueProperty" || evt.getPropertyName() == "ValueProperty")) {
                TStrengthIndicator.this.invalidate();
                TStrengthIndicator.this.repaint();
            }
        }
    }
}

