/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.pwstrength;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;

public class StrengthRangeModel {
    public static final String MAXIMUM_VALUE_PROPERTY = "MaximumValueProperty";
    public static final String MINIMUM_VALUE_PROPERTY = "MinimumValueProperty";
    public static final String VALUE_PROPERTY = "ValueProperty";
    private int minValue;
    private int maxValue;
    private int value;
    private LinkedList<PropertyChangeListener> changeListenerList = new LinkedList();

    public StrengthRangeModel(int minValue, int maxValue, int value) {
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
        this.setValue(value);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.changeListenerList.contains(listener)) {
            this.changeListenerList.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListenerList.remove(listener);
    }

    protected void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        int i = this.changeListenerList.size() - 1;
        while (i >= 0) {
            this.changeListenerList.get(i).propertyChange(evt);
            --i;
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        if (this.minValue != minValue) {
            int oldValue = this.minValue;
            this.minValue = minValue;
            this.firePropertyChanged(MINIMUM_VALUE_PROPERTY, oldValue, this.minValue);
            if (this.maxValue < this.minValue) {
                this.setMaxValue(this.minValue);
            }
            if (this.value < this.minValue) {
                this.setValue(this.minValue);
            }
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        if (this.maxValue != maxValue) {
            int oldValue = this.maxValue;
            this.maxValue = maxValue;
            this.firePropertyChanged(MAXIMUM_VALUE_PROPERTY, oldValue, this.maxValue);
            if (this.minValue > this.maxValue) {
                this.setMinValue(this.maxValue);
            }
            if (this.value > this.maxValue) {
                this.setValue(this.maxValue);
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value > this.maxValue) {
            value = this.maxValue;
        } else if (value < this.minValue) {
            value = this.minValue;
        }
        if (this.value != value) {
            int oldValue = this.value;
            this.value = value;
            this.firePropertyChanged(VALUE_PROPERTY, oldValue, this.value);
        }
    }
}

