/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.pwstrength;

public class PasswordStrengthCalculator {
    private PasswordStrengthCalculator() {
    }

    public static int calculatePasswordStrength(String password) {
        int strength = 0;
        if (password != null) {
            int codePoint = -1;
            int lowerCaseLetter = 0;
            int upperCaseLetter = 0;
            int digit = 0;
            int others = 0;
            int i = 0;
            int j = password.length();
            while (i < j) {
                codePoint = password.codePointAt(i);
                if (Character.isValidCodePoint(codePoint)) {
                    switch (Character.getType(codePoint)) {
                        case 2: {
                            ++lowerCaseLetter;
                            break;
                        }
                        case 1: {
                            ++upperCaseLetter;
                            break;
                        }
                        case 9: {
                            ++digit;
                            break;
                        }
                        default: {
                            ++others;
                        }
                    }
                }
                ++i;
            }
            strength = lowerCaseLetter + upperCaseLetter * 2 + digit * 5 + others * 12;
        }
        return strength;
    }

    public static int calcPwStrength(String in) {
        int minLen = 8;
        int xtraLen = 4;
        int result = 0;
        String[] partialRegexChecks = new String[]{".*[a-z]+.*", ".*[A-Z]+.*", ".*[\\d]+.*", ".*[@#$%!\\?\\+\\-\\{\\}\\[\\]\\(\\)\\*\\|]+.*"};
        int i = 0;
        while (i < partialRegexChecks.length) {
            if (in.matches(partialRegexChecks[i])) {
                ++result;
            }
            ++i;
        }
        if (result > 0) {
            --result;
        }
        if (in.length() < 8 && result > 1) {
            result = 1;
        }
        if (in.length() > 8) {
            int xtra = in.length() - 8;
            result += xtra / 4;
        }
        return result;
    }
}

