/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.progress;

import java.awt.Cursor;
import prospektservice.base.progress.ProgressPanel;

public class TimeProgressPanel
extends ProgressPanel {
    private static final long serialVersionUID = 3257852060572333106L;

    public TimeProgressPanel(int maxSeconds) {
        super(maxSeconds, 1000, true);
        this.initTimeProgressPanel();
    }

    public TimeProgressPanel(int maxSeconds, boolean isMessagesVisible) {
        super(maxSeconds, 1000, isMessagesVisible);
        this.initTimeProgressPanel();
    }

    public void changeProgressMaximum(int newMaxSeconds) {
        if (newMaxSeconds != this.currentProgressMaximum) {
            this.breakProgressTimer();
            this.currentProgressMaximum = newMaxSeconds > this.progressBar.getValue() ? newMaxSeconds : this.progressBar.getValue();
            this.progressBar.setMaximum(this.currentProgressMaximum);
            this.remainSecondsDuration = this.currentProgressMaximum - this.progressBar.getValue();
            this.progressBar.repaint();
            this.fireProgressEvent(105);
            this.restartProgressTimer();
        }
    }

    public void restartTimeProgress(int addMillisecondsDuration) {
        this.ppInstance.setCursor(Cursor.getPredefinedCursor(3));
        this.progressBar.setMaximum(this.currentProgressMaximum + addMillisecondsDuration / 1000);
        this.remainSecondsDuration = addMillisecondsDuration <= 0 ? 0 : (addMillisecondsDuration < 1000 ? 1 : addMillisecondsDuration / 1000);
        this.progressBar.repaint();
        this.refreshProgressMessages();
        super.restartProgress();
    }

    private void initTimeProgressPanel() {
        this.remainSecondsDuration = this.progressBar.getMaximum() - this.progressBar.getValue();
        this.refreshProgressMessages();
        this.ppInstance = this;
    }
}

