/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import prospektservice.PSEnvironment;
import prospektservice.base.PSImageIcon;

public class SpinButton
extends JPanel {
    private static final long serialVersionUID = 3257565092450154806L;
    public static final int SPIN_UP = 0;
    public static final int SPIN_DOWN = 1;
    private int SPIN_REPEAT_INTERVAL = 200;
    private JButton up;
    private JButton down;
    private JTextField child;
    private int minSpin = 0;
    private int maxSpin = 0;
    private int Step = 1;
    private Timer spinTimer;
    private ActionListener spinCallback;
    private int currentAction = -1;
    private boolean timerEnabled = false;
    private MouseAdapter mouseAdapter;

    public SpinButton() {
        this.setLayout(new GridLayout(2, 1));
        ActionListener spnAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SpinButton.this.child.getText().length() == 0) {
                    SpinButton.this.child.setText("" + SpinButton.this.minSpin);
                    SpinButton.this.child.firePropertyChange("Spinvalue", 0, SpinButton.this.minSpin);
                    return;
                }
                SpinButton.this.doSpinAction();
            }
        };
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getSource() == SpinButton.this.down) {
                    SpinButton.this.currentAction = 1;
                }
                if (e.getSource() == SpinButton.this.up) {
                    SpinButton.this.currentAction = 0;
                }
                if (SpinButton.this.timerEnabled) {
                    SpinButton.this.spinTimer.setDelay(SpinButton.this.SPIN_REPEAT_INTERVAL);
                    SpinButton.this.spinTimer.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SpinButton.this.timerEnabled) {
                    SpinButton.this.spinTimer.stop();
                }
            }
        };
        this.up = new JButton(new PSImageIcon("images/spin_up.gif"));
        this.up.setFocusPainted(false);
        this.up.setMargin(new Insets(0, 0, 0, 0));
        this.up.setActionCommand("0");
        this.up.addActionListener(spnAction);
        this.up.addMouseListener(this.mouseAdapter);
        this.add(this.up);
        this.down = new JButton(new PSImageIcon("images/spin_down.gif"));
        this.down.setMargin(new Insets(0, 0, 0, 0));
        this.down.setFocusPainted(false);
        this.down.setActionCommand("1");
        this.down.addActionListener(spnAction);
        this.down.addMouseListener(this.mouseAdapter);
        this.add(this.down);
        this.spinCallback = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinButton.this.doSpinAction();
            }
        };
        this.spinTimer = new Timer(this.SPIN_REPEAT_INTERVAL, this.spinCallback);
    }

    public int getMaxSpinValue() {
        return this.maxSpin;
    }

    public int getMinSpinValue() {
        return this.minSpin;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.up.setEnabled(flag);
        this.down.setEnabled(flag);
    }

    public void setChildField(JTextField value) {
        this.child = value;
        this.child.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (SpinButton.this.child.getText().length() == 0) {
                    SpinButton.this.child.setText("" + SpinButton.this.minSpin);
                } else if (PSEnvironment.getIntValue(SpinButton.this.child.getText()) < SpinButton.this.minSpin) {
                    SpinButton.this.child.setText("" + SpinButton.this.minSpin);
                } else if (PSEnvironment.getIntValue(SpinButton.this.child.getText()) > SpinButton.this.maxSpin) {
                    SpinButton.this.child.setText("" + SpinButton.this.maxSpin);
                }
            }
        });
    }

    public void setMaxSpinValue(int value) {
        this.maxSpin = value;
    }

    public void setMinSpinValue(int value) {
        this.minSpin = value;
    }

    public void setSpinStep(int value) {
        this.Step = value;
    }

    @Override
    public void setToolTipText(String value) {
        this.up.setToolTipText(value);
        this.down.setToolTipText(value);
    }

    private void doSpinAction() {
        int actvalue;
        int newvalue = actvalue = PSEnvironment.getIntValue(this.child.getText());
        if (this.currentAction == 1 && actvalue - this.Step >= this.minSpin) {
            newvalue = actvalue - this.Step;
        }
        if (this.currentAction == 0 && actvalue + this.Step <= this.maxSpin) {
            newvalue = actvalue + this.Step;
        }
        if (newvalue != actvalue) {
            this.child.setText("" + newvalue);
            this.child.firePropertyChange("Spinvalue", actvalue, newvalue);
        }
    }

    public void enableTimer(boolean enable) {
        this.timerEnabled = enable;
    }

    public boolean isTimerEnabled() {
        return this.timerEnabled;
    }

    public void setSpinRepeatInterval(int millis) {
        this.SPIN_REPEAT_INTERVAL = millis;
    }

    public int getSpinRepeatInterval() {
        return this.SPIN_REPEAT_INTERVAL;
    }

    public JButton getUpButton() {
        return this.up;
    }

    public JButton getDownButton() {
        return this.down;
    }
}

