/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import prospektservice.PSEnvironment;

public class AutoProxyHelper {
    private static InputStream jscriptsLocation;
    private static ArrayList<String> proxyList;
    private static int proxyCnt;

    static {
        proxyCnt = 0;
        try {
            jscriptsLocation = AutoProxyHelper.class.getResourceAsStream("proxyhelp.js");
        }
        catch (Exception ioEx) {
            ioEx.printStackTrace();
        }
    }

    public static BufferedReader grabProxyScript(String url) {
        BufferedReader br = null;
        try {
            URL scriptUrl = new URL(url);
            URLConnection con = scriptUrl.openConnection();
            br = new BufferedReader(new InputStreamReader(con.getInputStream()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return br;
    }

    public static String FindProxyWrap(String proxyFunction, String host, String url) {
        Object result = null;
        String report = "";
        Context cx = Context.enter();
        try {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(jscriptsLocation));
                ScriptableObject scope = cx.initStandardObjects();
                result = cx.evaluateReader((Scriptable)scope, (Reader)br, "proxyhelp.js", 0, null);
                result = cx.evaluateReader((Scriptable)scope, (Reader)AutoProxyHelper.grabProxyScript(proxyFunction), "proxyFunction", 0, null);
                Object fProxy = scope.get("FindProxyForURL", (Scriptable)scope);
                Object[] functionArgs = new Object[]{url, host};
                Function f = (Function)fProxy;
                result = f.call(cx, (Scriptable)scope, (Scriptable)scope, functionArgs);
                report = Context.toString((Object)result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
        return report;
    }

    public static boolean getAutomaticProxy(String url) {
        boolean result = false;
        try {
            String host = PSEnvironment.getPSClientProperty("PS.Server.IP", "ps1.mailingfactory.de");
            String fullServerURL = String.valueOf(host) + ":" + PSEnvironment.getPSClientProperty("PS.Server.Port", "8080") + "/";
            fullServerURL = String.valueOf(fullServerURL) + PSEnvironment.getPSClientProperty("PS.Server.Servlet", "PSOServlets/PsoConnection");
            String scriptResult = AutoProxyHelper.FindProxyWrap(url, host, fullServerURL);
            if (PSEnvironment.DEBUG) {
                System.out.println("proxy script result" + scriptResult);
            }
            if (scriptResult.indexOf(";") > -1) {
                proxyList = new ArrayList();
                StringTokenizer t = new StringTokenizer(scriptResult, ";");
                while (t.hasMoreTokens()) {
                    String actProxy = t.nextToken();
                    proxyList.add(actProxy);
                }
                String useProxy = proxyList.get(0);
                if (useProxy.indexOf("PROXY ") > -1) {
                    int collonIndex = useProxy.indexOf(":");
                    String proxy = useProxy.substring(6, collonIndex);
                    String port = useProxy.substring(++collonIndex);
                    Properties props = System.getProperties();
                    props.put("http.proxyHost", proxy);
                    props.put("http.proxyPort", port);
                    props.put("http.proxySet", "true");
                    props.put("https.proxyHost", proxy);
                    props.put("https.proxyPort", port);
                    props.put("https.proxySet", "true");
                    System.setProperties(props);
                    if (PSEnvironment.DEBUG) {
                        System.out.println("using proxy " + proxy + ":" + port);
                    }
                    result = true;
                }
            } else if (scriptResult.indexOf("PROXY ") > -1) {
                int collonIndex = scriptResult.indexOf(":");
                String proxy = scriptResult.substring(6, collonIndex);
                String port = scriptResult.substring(++collonIndex);
                Properties props = System.getProperties();
                props.put("http.proxyHost", proxy);
                props.put("http.proxyPort", port);
                props.put("http.proxySet", "true");
                props.put("https.proxyHost", proxy);
                props.put("https.proxyPort", port);
                props.put("https.proxySet", "true");
                System.setProperties(props);
                if (PSEnvironment.DEBUG) {
                    System.out.println("using proxy " + proxy + ":" + port);
                }
                result = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static boolean moreProxiesAvailable() {
        return proxyCnt < proxyList.size();
    }

    private boolean testProxy(String host, int port) {
        boolean result = false;
        try {
            Socket s = new Socket(host, port);
            PrintWriter pw = new PrintWriter(s.getOutputStream());
            pw.println("GET http://ps1.mailingfactory.de:8080");
            pw.println("Host: ps1.mailingfactory.de");
            pw.println();
            pw.flush();
            DataInputStream dIn = new DataInputStream(s.getInputStream());
            byte[] data = new byte[s.getReceiveBufferSize()];
            int read = 0;
            while ((read = dIn.read(data)) != -1) {
                String answer = new String(data);
                if (!answer.startsWith("HTTP/1.0 2") && !answer.startsWith("HTTP/1.1 2")) continue;
                result = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

