/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.layer.painter;

import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.jdesktop.swinghelper.layer.JXLayer;
import org.jdesktop.swinghelper.layer.painter.AbstractPainter;
import org.jdesktop.swinghelper.layer.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundPainter<V extends JComponent>
extends AbstractPainter<V> {
    private Painter[] painters = new Painter[0];

    public CompoundPainter() {
        this((Painter[])null);
    }

    public CompoundPainter(Painter<V> ... painters) {
        this.setPainters(painters);
    }

    public Painter<V>[] getPainters() {
        Painter[] result = new Painter[this.painters.length];
        System.arraycopy(this.painters, 0, result, 0, result.length);
        return result;
    }

    public void setPainters(Painter<V> ... painters) {
        if (painters == null) {
            painters = new Painter[]{};
        }
        for (Painter<V> painter : this.getPainters()) {
            painter.removeLayerItemListener(this);
        }
        this.painters = new Painter[painters.length];
        System.arraycopy(painters, 0, this.painters, 0, painters.length);
        for (Painter<V> painter : painters) {
            painter.addLayerItemListener(this);
        }
        this.fireLayerItemChanged();
    }

    @Override
    public void paint(Graphics2D g2, JXLayer<V> l) {
        this.configure(g2, l);
        for (Painter painter : this.painters) {
            Graphics2D temp = (Graphics2D)g2.create();
            if (painter.isEnabled()) {
                painter.paint(temp, l);
            }
            temp.dispose();
        }
    }
}

