/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.layer.painter;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.swinghelper.layer.JXLayer;
import org.jdesktop.swinghelper.layer.item.AbstractLayerItem;
import org.jdesktop.swinghelper.layer.item.LayerItemEvent;
import org.jdesktop.swinghelper.layer.item.LayerItemListener;
import org.jdesktop.swinghelper.layer.painter.Painter;
import org.jdesktop.swinghelper.layer.painter.model.DefaultPainterModel;
import org.jdesktop.swinghelper.layer.painter.model.PainterModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPainter<V extends JComponent>
extends AbstractLayerItem
implements Painter<V>,
LayerItemListener {
    private PainterModel model;

    protected AbstractPainter() {
        this(new DefaultPainterModel());
    }

    protected AbstractPainter(PainterModel model) {
        if (model == null) {
            throw new IllegalArgumentException("PainterModel is null");
        }
        this.model = model;
        model.addLayerItemListener(this);
    }

    @Override
    public PainterModel getModel() {
        return this.model;
    }

    protected void configure(Graphics2D g2, JXLayer<V> l) {
        if (this.getModel().isEnabled()) {
            this.applyComposite(g2, this.getComposite(l));
            this.applyTransform(g2, this.getTransform(l));
            this.applyClip(g2, this.getClip(l));
            this.applyRenderingHints(g2, this.getRenderingHints(l));
        }
    }

    @Override
    public abstract void paint(Graphics2D var1, JXLayer<V> var2);

    public Composite getComposite(JXLayer<V> l) {
        return this.getModel().getComposite();
    }

    public AffineTransform getTransform(JXLayer<V> l) {
        return this.getModel().getTransform();
    }

    public Shape getClip(JXLayer<V> l) {
        return this.getModel().getClip();
    }

    public Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<V> l) {
        return this.getModel().getRenderingHints();
    }

    protected void applyComposite(Graphics2D g2, Composite composite) {
        if (composite != null) {
            g2.setComposite(composite);
        }
    }

    protected void applyTransform(Graphics2D g2, AffineTransform transform) {
        if (transform != null) {
            g2.transform(transform);
        }
    }

    protected void applyClip(Graphics2D g2, Shape clip) {
        if (clip != null) {
            if (g2.getClip() == null) {
                g2.setClip(clip);
            } else {
                Area clipArea = new Area(g2.getClip());
                clipArea.intersect(new Area(clip));
                g2.setClip(clipArea);
            }
        }
    }

    protected void applyRenderingHints(Graphics2D g2, Map<RenderingHints.Key, Object> hints) {
        if (hints != null) {
            for (RenderingHints.Key key : hints.keySet()) {
                Object value = hints.get(key);
                if (value == null) continue;
                g2.setRenderingHint(key, hints.get(key));
            }
        }
    }

    @Override
    public void layerItemChanged(LayerItemEvent e) {
        this.fireLayerItemChanged(e.getClip());
    }

    @Override
    public boolean contains(int x, int y, JXLayer<V> l) {
        Shape clip = this.getClip(l);
        return clip == null || clip.contains(x, y);
    }
}

