/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.layer.effect;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import org.jdesktop.swinghelper.layer.effect.Effect;
import org.jdesktop.swinghelper.layer.item.AbstractLayerItem;

public class ImageOpEffect
extends AbstractLayerItem
implements Effect {
    private BufferedImageOp bufferedImageOp;
    private BufferedImage srcBuffer;

    public ImageOpEffect() {
    }

    public ImageOpEffect(BufferedImageOp bufferedImageOp) {
        this.bufferedImageOp = bufferedImageOp;
    }

    public BufferedImageOp getBufferedImageOp() {
        return this.bufferedImageOp;
    }

    public void setBufferedImageOp(BufferedImageOp bufferedImageOp) {
        this.bufferedImageOp = bufferedImageOp;
        this.fireLayerItemChanged();
    }

    public void apply(BufferedImage buffer, Shape clip) {
        Rectangle clipBounds;
        if (this.bufferedImageOp == null) {
            return;
        }
        if (buffer == null) {
            throw new IllegalArgumentException("BufferedImage is null");
        }
        Rectangle bufferSize = new Rectangle(buffer.getWidth(), buffer.getHeight());
        if (clip == null) {
            clip = bufferSize;
        }
        if ((clipBounds = clip.getBounds().intersection(bufferSize)).isEmpty() || buffer.getWidth() <= clipBounds.x || buffer.getHeight() <= clipBounds.y) {
            return;
        }
        int x = clipBounds.x;
        int y = clipBounds.y;
        int width = clipBounds.width;
        int height = clipBounds.height;
        if (buffer.getWidth() < x + width) {
            width = buffer.getWidth() - x;
        }
        if (buffer.getHeight() < y + height) {
            height = buffer.getHeight() - y;
        }
        if (this.srcBuffer == null || this.srcBuffer.getWidth() != width || this.srcBuffer.getHeight() != height) {
            this.srcBuffer = new BufferedImage(width, height, buffer.getType());
        }
        BufferedImage subImage = buffer.getSubimage(x, y, width, height);
        subImage.copyData(this.srcBuffer.getRaster());
        this.bufferedImageOp.filter(this.srcBuffer, subImage);
    }
}

