/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class BitsetArgument
extends AbstractArgument {
    private JCheckBox[] options;

    public BitsetArgument(AbstractTool tool, String name, String description, String[] options) {
        super(tool, name, description, null);
        this.options = new JCheckBox[options.length];
        int i = 0;
        while (i < options.length) {
            this.options[i] = new JCheckBox(options[i]);
            ++i;
        }
    }

    @Override
    public String getUsage() {
        StringBuilder buf = new StringBuilder(super.getUsage());
        buf.append("    possible options:\n");
        JCheckBox[] jCheckBoxArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            JCheckBox option = jCheckBoxArray[n2];
            buf.append("    - ");
            buf.append(option.getText());
            buf.append('\n');
            ++n2;
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object[] message = new Object[1 + this.options.length];
        message[0] = "Check the options you need:";
        System.arraycopy(this.options, 0, message, 1, this.options.length);
        int result = JOptionPane.showOptionDialog(this.tool.getInternalFrame(), message, this.description, 2, 3, null, null, null);
        if (result == 0) {
            StringBuilder buf = new StringBuilder();
            JCheckBox[] jCheckBoxArray = this.options;
            int n = this.options.length;
            int n2 = 0;
            while (n2 < n) {
                JCheckBox option = jCheckBoxArray[n2];
                if (option.isSelected()) {
                    buf.append('1');
                } else {
                    buf.append('0');
                }
                ++n2;
            }
            this.setValue(buf.toString());
        }
    }
}

