/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;

public class TextAreaOutputStream
extends OutputStream {
    protected JTextArea text;
    protected int offset;

    public TextAreaOutputStream(JTextArea text) {
        this.text = text;
        this.clear();
    }

    public void clear() {
        this.text.setText(null);
        this.offset = 0;
    }

    @Override
    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)i};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        String snippet = new String(b, off, len);
        this.text.insert(snippet, this.offset);
        this.offset += len - off;
    }

    @Override
    public void write(byte[] b) throws IOException {
        int bytesread;
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        byte[] snippet = new byte[1024];
        while ((bytesread = bais.read(snippet)) > 0) {
            this.write(snippet, 0, bytesread);
        }
    }
}

