/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    public static final Class hierarchicalColumnClass = TreeTableModel.class;
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTreeTableModel() {
        this(null);
    }

    public AbstractTreeTableModel(Object object) {
        this.root = object;
    }

    public Class getColumnClass(int n) {
        return n == 0 ? hierarchicalColumnClass : Object.class;
    }

    public String getColumnName(int n) {
        return "Column " + n;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        try {
            return ((TreeNode)object).getChildAt(n);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public int getChildCount(Object object) {
        try {
            return ((TreeNode)object).getChildCount();
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    public int getColumnCount() {
        return 1;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        try {
            return ((TreeNode)object).getIndex((TreeNode)object2);
        }
        catch (ClassCastException classCastException) {
            for (int i = 0; i < this.getChildCount(object); ++i) {
                if (!this.getChild(object, i).equals(object2)) continue;
                return i;
            }
            return -1;
        }
    }

    public boolean isCellEditable(Object object, int n) {
        return false;
    }

    public boolean isLeaf(Object object) {
        try {
            return ((TreeNode)object).isLeaf();
        }
        catch (ClassCastException classCastException) {
            return this.getChildCount(object) == 0;
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

