/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.Length;

public abstract class ConfigurableBarcodeGenerator
implements BarcodeGenerator,
Configurable {
    public static final String[] BARCODE_ELEMENTS;
    protected AbstractBarcodeBean bean;

    public void configure(Configuration cfg) throws ConfigurationException {
        Configuration hr;
        String qzvs;
        Configuration c = cfg.getChild("height", false);
        if (c != null) {
            Length h = new Length(c.getValue(), "mm");
            this.getBean().setHeight(h.getValueAsMillimeter());
        }
        this.getBean().doQuietZone(cfg.getChild("quiet-zone").getAttributeAsBoolean("enabled", true));
        String qzs = cfg.getChild("quiet-zone").getValue(null);
        if (qzs != null) {
            Length qz = new Length(qzs, "mw");
            if (qz.getUnit().equalsIgnoreCase("mw")) {
                this.getBean().setQuietZone(qz.getValue() * this.getBean().getModuleWidth());
            } else {
                this.getBean().setQuietZone(qz.getValueAsMillimeter());
            }
        }
        if ((qzvs = cfg.getChild("vertical-quiet-zone").getValue(null)) != null) {
            Length qz = new Length(qzvs, "in");
            if (qz.getUnit().equalsIgnoreCase("mw")) {
                this.getBean().setVerticalQuietZone(qz.getValue() * this.getBean().getModuleWidth());
            } else {
                this.getBean().setVerticalQuietZone(qz.getValueAsMillimeter());
            }
        }
        if ((hr = cfg.getChild("human-readable", false)) != null && hr.getChildren().length > 0) {
            String v = hr.getChild("placement").getValue(null);
            if (v != null) {
                this.getBean().setMsgPosition(HumanReadablePlacement.byName(v));
            }
            if ((c = hr.getChild("font-size", false)) != null) {
                Length fs = new Length(c.getValue());
                this.getBean().setFontSize(fs.getValueAsMillimeter());
            }
            this.getBean().setFontName(hr.getChild("font-name").getValue("Helvetica"));
            this.getBean().setPattern(hr.getChild("pattern").getValue(""));
        } else {
            String v = cfg.getChild("human-readable").getValue(null);
            if (v != null) {
                this.getBean().setMsgPosition(HumanReadablePlacement.byName(v));
            }
            if ((c = cfg.getChild("human-readable-size", false)) != null) {
                Length fs = new Length(c.getValue());
                this.getBean().setFontSize(fs.getValueAsMillimeter());
            }
            this.getBean().setFontName(cfg.getChild("human-readable-font").getValue("Helvetica"));
        }
    }

    public AbstractBarcodeBean getBean() {
        return this.bean;
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        this.getBean().generateBarcode(canvas, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        return this.getBean().calcDimensions(msg);
    }

    static {
        ArrayList<String> elements = new ArrayList<String>();
        elements.addAll(BarcodeUtil.getInstance().getClassResolver().getBarcodeNames());
        elements.add("height");
        elements.add("module-width");
        elements.add("wide-factor");
        elements.add("quiet-zone");
        elements.add("vertical-quiet-zone");
        elements.add("checksum");
        elements.add("human-readable");
        elements.add("human-readable-font");
        elements.add("human-readable-size");
        elements.add("font-name");
        elements.add("font-size");
        elements.add("placement");
        elements.add("pattern");
        elements.add("display-start-stop");
        elements.add("display-checksum");
        elements.add("interchar-gap-width");
        elements.add("tall-bar-height");
        elements.add("short-bar-height");
        elements.add("track-height");
        elements.add("ascender-height");
        elements.add("baseline-alignment");
        elements.add("template");
        elements.add("group-separator");
        elements.add("check-digit-marker");
        elements.add("omit-brackets");
        elements.add("shape");
        elements.add("row-height");
        elements.add("columns");
        elements.add("min-columns");
        elements.add("max-columns");
        elements.add("min-rows");
        elements.add("max-rows");
        elements.add("ec-level");
        elements.add("width-to-height-ratio");
        elements.add("min-symbol-size");
        elements.add("max-symbol-size");
        elements.add("codesets");
        elements.add("bearer-bar-width");
        elements.add("bearer-box");
        BARCODE_ELEMENTS = elements.toArray(new String[elements.size()]);
    }
}

