/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.math.ec.ECFieldElement;

public class X9FieldElement
implements DEREncodable {
    private ECFieldElement f;

    public X9FieldElement(ECFieldElement eCFieldElement) {
        this.f = eCFieldElement;
    }

    public X9FieldElement(boolean bl, BigInteger bigInteger, DEROctetString dEROctetString) {
        if (bl) {
            this.f = new ECFieldElement.Fp(bigInteger, new BigInteger(1, dEROctetString.getOctets()));
            return;
        }
        throw new RuntimeException("not implemented");
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    public DERObject getDERObject() {
        return new DEROctetString(this.f.toBigInteger().toByteArray());
    }
}

