/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class OriginatorIdentifierOrKey
extends CMSObject {
    private DEREncodable id;

    public OriginatorIdentifierOrKey(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public OriginatorIdentifierOrKey(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.setId(subjectKeyIdentifier);
    }

    public OriginatorIdentifierOrKey(OriginatorPublicKey originatorPublicKey) {
        this.setId(originatorPublicKey);
    }

    public OriginatorIdentifierOrKey(DERObject dERObject) {
        if (dERObject instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)dERObject;
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.id = SubjectKeyIdentifier.getInstance(aSN1TaggedObject, false);
                    return;
                }
                case 1: {
                    this.id = OriginatorPublicKey.getInstance(aSN1TaggedObject, false);
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey: " + dERObject.getClass().getName());
        }
        this.id = IssuerAndSerialNumber.getInstance(dERObject);
    }

    public OriginatorIdentifierOrKey(OriginatorIdentifierOrKey originatorIdentifierOrKey) {
        this.id = originatorIdentifierOrKey.id;
    }

    public static OriginatorIdentifierOrKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return OriginatorIdentifierOrKey.getInstance(aSN1TaggedObject);
    }

    public static OriginatorIdentifierOrKey getInstance(Object object) {
        if (object == null || object instanceof OriginatorIdentifierOrKey) {
            return (OriginatorIdentifierOrKey)object;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new OriginatorIdentifierOrKey((IssuerAndSerialNumber)object);
        }
        if (object instanceof SubjectKeyIdentifier) {
            return new OriginatorIdentifierOrKey((SubjectKeyIdentifier)object);
        }
        if (object instanceof OriginatorPublicKey) {
            return new OriginatorIdentifierOrKey((OriginatorPublicKey)object);
        }
        if (object instanceof DERObject) {
            return new OriginatorIdentifierOrKey((DERObject)object);
        }
        throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey: " + object.getClass().getName());
    }

    public DEREncodable getId() {
        return this.id;
    }

    public DERObject getDERObject() {
        if (this.id instanceof SubjectKeyIdentifier) {
            return new BERTaggedObject(false, 0, this.id.getDERObject());
        }
        if (this.id instanceof OriginatorPublicKey) {
            return new BERTaggedObject(false, 1, this.id.getDERObject());
        }
        return this.id.getDERObject();
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    private void setId(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier;
    }

    private void setId(OriginatorPublicKey originatorPublicKey) {
        this.id = originatorPublicKey;
    }
}

