/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.ExtendedCertificateInfo;
import org.bouncycastle.asn1.cms.Signature;
import org.bouncycastle.asn1.cms.SignatureAlgorithmIdentifier;

public class ExtendedCertificate
extends CMSObject {
    private ExtendedCertificateInfo extendedCertificateInfo;
    private SignatureAlgorithmIdentifier signatureAlgorithm;
    private Signature signature;

    public ExtendedCertificate(ASN1Sequence aSN1Sequence) {
        this.extendedCertificateInfo = ExtendedCertificateInfo.getInstance(aSN1Sequence.getObjectAt(0));
        this.signatureAlgorithm = SignatureAlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.signature = Signature.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public ExtendedCertificate(ExtendedCertificate extendedCertificate) {
        this.extendedCertificateInfo = extendedCertificate.extendedCertificateInfo;
        this.signatureAlgorithm = extendedCertificate.signatureAlgorithm;
        this.signature = extendedCertificate.signature;
    }

    public static ExtendedCertificate getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ExtendedCertificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ExtendedCertificate getInstance(Object object) {
        if (object == null || object instanceof ExtendedCertificate) {
            return (ExtendedCertificate)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ExtendedCertificate((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid ExtendedCertificate: " + object.getClass().getName());
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.extendedCertificateInfo);
        dERConstructedSequence.addObject(this.signatureAlgorithm);
        dERConstructedSequence.addObject(this.signature);
        return dERConstructedSequence;
    }

    protected static int getASN1Type() {
        return 1;
    }
}

