/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class CMSVersion
extends CMSObject {
    private DERInteger version;

    public CMSVersion(BigInteger bigInteger) {
        this.setVersion(bigInteger);
    }

    public CMSVersion(DERInteger dERInteger) {
        this.version = dERInteger;
    }

    public CMSVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion.version;
    }

    public static CMSVersion getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CMSVersion.getInstance(DERInteger.getInstance(aSN1TaggedObject, bl));
    }

    public static CMSVersion getInstance(Object object) {
        if (object == null || object instanceof CMSVersion) {
            return (CMSVersion)object;
        }
        return new CMSVersion(DERInteger.getInstance(object));
    }

    public BigInteger getVersion() {
        return this.version.getValue();
    }

    public DERObject getDERObject() {
        return this.version;
    }

    private void setVersion(BigInteger bigInteger) {
        this.version = new DERInteger(bigInteger);
    }
}

