/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher c;
    private byte[] oneByte = new byte[1];

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        this.c = cipher;
    }

    protected CipherOutputStream(OutputStream outputStream) {
        this(outputStream, new NullCipher());
    }

    public void write(int n) throws IOException {
        this.oneByte[0] = (byte)n;
        byte[] byArray = this.c.update(this.oneByte, 0, 1);
        if (byArray != null) {
            this.out.write(byArray, 0, byArray.length);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.c.update(byArray, n, n2);
        if (byArray2 != null) {
            this.out.write(byArray2, 0, byArray2.length);
        }
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void close() throws IOException {
        try {
            byte[] byArray = this.c.doFinal();
            if (byArray != null) {
                this.out.write(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            throw new IOException("Error closing stream: " + exception.toString());
        }
        this.flush();
        super.close();
    }
}

