/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected AbstractList() {
    }

    public boolean add(Object object) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException {
        this.add(this.size(), object);
        return true;
    }

    public abstract Object get(int var1) throws IndexOutOfBoundsException;

    public Object set(int n, Object object) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    public void add(int n, Object object) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) throws UnsupportedOperationException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            int n = listIterator.nextIndex();
            Object object2 = listIterator.next();
            if (!(object == null ? object2 == null : object.equals(object2))) continue;
            return n;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.size());
        while (listIterator.hasPrevious()) {
            int n = listIterator.previousIndex();
            Object object2 = listIterator.previous();
            if (!(object == null ? object2 == null : object.equals(object2))) continue;
            return n;
        }
        return -1;
    }

    public void clear() throws UnsupportedOperationException {
        this.removeRange(0, this.size());
        return;
    }

    public boolean addAll(int n, Collection collection) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException, IndexOutOfBoundsException {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
            bl = true;
        }
        return bl;
    }

    public Iterator iterator() {
        return new AbstractListIterator(this);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractListListIterator(this);
    }

    public List subList(int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException("subList() not implemented yet!");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((List)object).iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            Object object2 = iterator.next();
            Object object3 = iterator2.next();
            if (object2 == null && object3 != null) {
                return false;
            }
            if (object2.equals(object3)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    protected void removeRange(int n, int n2) {
        if (n == n2) {
            return;
        }
        ListIterator listIterator = this.listIterator(n);
        int n3 = n;
        do {
            listIterator.next();
            listIterator.remove();
        } while (listIterator.hasNext() && ++n3 < n2);
    }

    private class AbstractListIterator
    implements Iterator {
        AbstractList m_al;
        int m_nextIndex;

        public AbstractListIterator(AbstractList abstractList2) {
            AbstractList.this = AbstractList.this;
            this.m_al = abstractList2;
            this.m_nextIndex = 0;
        }

        public boolean hasNext() {
            return this.m_nextIndex < AbstractList.this.size();
        }

        public Object next() {
            return this.m_al.get(this.m_nextIndex++);
        }

        public void remove() {
            this.m_al.remove(this.m_nextIndex - 1);
        }
    }

    private class AbstractListListIterator
    extends AbstractListIterator
    implements ListIterator {
        public AbstractListListIterator(AbstractList abstractList2) {
            super(abstractList2);
            AbstractList.this = AbstractList.this;
        }

        public boolean hasPrevious() {
            return this.m_nextIndex > 0;
        }

        public Object previous() {
            return this.m_al.get(--this.m_nextIndex);
        }

        public int nextIndex() {
            return this.m_nextIndex;
        }

        public int previousIndex() {
            return this.m_nextIndex - 1;
        }

        public void set(Object object) {
            this.m_al.set(this.m_nextIndex - 1, object);
        }

        public void add(Object object) {
            this.m_al.add(this.m_nextIndex - 1, object);
        }
    }

    private abstract class AbstractSubList
    extends AbstractList {
        AbstractList m_al;
        int m_fromIndex;
        int m_toIndex;
        int size;

        public AbstractSubList(AbstractList abstractList2, int n, int n2) {
            AbstractList.this = AbstractList.this;
            this.m_al = abstractList2;
            this.m_toIndex = n2;
            this.m_fromIndex = n;
        }
    }
}

