/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

class SecurityUtil {
    private static Implementation getImplementation(String string, String string2, Provider provider) {
        String string3;
        while ((string3 = ((Properties)provider).getProperty("Alg.Alias." + string + "." + string2)) != null) {
            string2 = string3;
        }
        String string4 = ((Properties)provider).getProperty(String.valueOf(string) + "." + string2);
        if (string4 != null) {
            try {
                return new Implementation(Class.forName(string4).newInstance(), provider);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but no class found!");
            }
            catch (Exception exception) {
                throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but class inaccessible!");
            }
        }
        return null;
    }

    static Implementation getImplementation(String string, String string2, String string3) throws NoSuchProviderException {
        if (string3 == null) {
            Provider[] providerArray = Security.getProviders();
            int n = 0;
            while (n != providerArray.length) {
                Implementation implementation = SecurityUtil.getImplementation(string, string2, providerArray[n]);
                if (implementation != null) {
                    return implementation;
                }
                ++n;
            }
        } else {
            Provider provider = Security.getProvider(string3);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string3 + " not found");
            }
            return SecurityUtil.getImplementation(string, string2, provider);
        }
        return null;
    }

    SecurityUtil() {
    }

    static class Implementation {
        Object engine;
        Provider provider;

        Implementation(Object object, Provider provider) {
            this.engine = object;
            this.provider = provider;
        }

        Object getEngine() {
            return this.engine;
        }

        Provider getProvider() {
            return this.provider;
        }
    }
}

