/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecurityUtil;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public class KeyStore {
    private KeyStoreSpi keyStoreSpi;
    private Provider provider;
    private String type;
    private boolean initialised;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = string;
        this.initialised = false;
    }

    public final Enumeration aliases() throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineContainsAlias(string);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        this.keyStoreSpi.engineDeleteEntry(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineGetCertificate(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineGetCertificateAlias(certificate);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineGetCertificateChain(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineGetCreationDate(string);
    }

    public static final String getDefaultType() {
        return "JKS";
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        try {
            SecurityUtil.Implementation implementation = SecurityUtil.getImplementation("KeyStore", string, null);
            if (implementation != null) {
                return new KeyStore((KeyStoreSpi)implementation.getEngine(), implementation.getProvider(), string);
            }
            throw new KeyStoreException("can't find type " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreException(String.valueOf(string) + " not found");
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        SecurityUtil.Implementation implementation = SecurityUtil.getImplementation("KeyStore", string, string2);
        if (implementation != null) {
            return new KeyStore((KeyStoreSpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        throw new KeyStoreException("can't find type " + string);
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineGetKey(string, cArray);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineIsCertificateEntry(string);
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineIsKeyEntry(string);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(inputStream, cArray);
        this.initialised = true;
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        this.keyStoreSpi.engineSetCertificateEntry(string, certificate);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final int size() throws KeyStoreException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        return this.keyStoreSpi.engineSize();
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialised) {
            throw new KeyStoreException("KeyStore not initialised.");
        }
        this.keyStoreSpi.engineStore(outputStream, cArray);
    }
}

