/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public abstract class ImageWrapperDecorationPainter
implements SubstanceDecorationPainter {
    protected Image originalTile = null;
    protected SubstanceDecorationPainter baseDecorationPainter;
    protected LinkedHashMap<String, Image> colorizedTileMap = new LinkedHashMap<String, Image>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Image> eldest) {
            return this.size() > 10;
        }
    };
    protected float textureAlpha = 0.3f;
    protected boolean isPaintingSeparators = false;

    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceTheme theme) {
        switch (decorationAreaType) {
            case PRIMARY_TITLE_PANE: 
            case SECONDARY_TITLE_PANE: {
                this.paintTitleBackground(graphics, comp, decorationAreaType, width, height, theme);
                break;
            }
            default: {
                this.paintExtraBackground(graphics, SubstanceCoreUtilities.getHeaderParent(comp), comp, decorationAreaType, width, height, theme);
            }
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceTheme theme) {
        SubstanceTheme tileTheme = theme;
        if (this.baseDecorationPainter == null) {
            tileTheme = theme.getActiveTitlePaneTheme();
            graphics.setColor(tileTheme.getColorScheme().getMidColor());
            graphics.fillRect(0, 0, width, height);
        } else {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, width, height, theme);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileTheme, 0, 0, 0, 0, width, height);
        if (this.isPaintingSeparators) {
            temp.translate(0, height - 1);
            SubstanceCoreUtilities.paintSeparator(comp, temp, theme.getActiveTitlePaneTheme().getColorScheme(), SubstanceCoreUtilities.isThemeDark(theme.getActiveTitlePaneTheme()), width, 1, 0, false, 0);
            temp.dispose();
        }
    }

    private void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceTheme theme) {
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        int dx = 0;
        int dy = 0;
        JComponent titlePane = null;
        if (rootPane != null && (titlePane = SubstanceCoreUtilities.getTitlePane(rootPane)) != null) {
            if (comp.isShowing() && titlePane.isShowing()) {
                dx += comp.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
                dy += comp.getLocationOnScreen().y - titlePane.getLocationOnScreen().y;
            } else {
                Component c;
                dx = 0;
                dy = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                    dy += c.getY();
                }
                for (c = titlePane; c != rootPane; c = c.getParent()) {
                    dx -= c.getX();
                    dy -= c.getY();
                }
            }
        }
        SubstanceTheme tileTheme = theme;
        if (this.baseDecorationPainter != null) {
            this.baseDecorationPainter.paintDecorationArea(graphics, comp, decorationAreaType, width, height, theme);
        } else {
            tileTheme = theme.getActiveTitlePaneTheme();
            graphics.setColor(tileTheme.getColorScheme().getMidColor());
            graphics.fillRect(0, 0, width, height);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileTheme, dx, dy, 0, 0, width, height);
        if (this.isPaintingSeparators) {
            int totalOffsetY = height - 1;
            int deltaY = 0;
            Component c = comp;
            while (c.getParent() != null) {
                Container cParent = c.getParent();
                deltaY += cParent.getHeight() - (c.getHeight() + c.getY());
                if (SubstanceDecorationUtilities.getImmediateDecorationType(cParent) != null) {
                    totalOffsetY += deltaY;
                    deltaY = 0;
                }
                c = cParent;
            }
            int pWidth = titlePane == null ? parent.getWidth() : titlePane.getWidth();
            temp.translate(-dx, totalOffsetY);
            SubstanceCoreUtilities.paintSeparator(comp, temp, theme.getActiveTitlePaneTheme().getColorScheme(), SubstanceCoreUtilities.isThemeDark(theme.getActiveTitlePaneTheme()), pWidth, 1, 0, false, 0);
        }
        temp.dispose();
    }

    protected void tileArea(Graphics2D g, Component comp, SubstanceTheme tileTheme, int offsetTextureX, int offsetTextureY, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(comp, this.textureAlpha, g));
        Image colorizedTile = this.getColorizedTile(tileTheme);
        int tileWidth = colorizedTile.getWidth(null);
        int tileHeight = colorizedTile.getHeight(null);
        offsetTextureX %= tileWidth;
        int currTileTop = -(offsetTextureY %= tileHeight);
        do {
            int currTileLeft = -offsetTextureX;
            do {
                graphics.drawImage(colorizedTile, currTileLeft, currTileTop, null);
            } while ((currTileLeft += tileWidth) < width);
        } while ((currTileTop += tileHeight) < height);
        graphics.dispose();
    }

    public void setBaseDecorationPainter(SubstanceDecorationPainter baseDecorationPainter) {
        this.baseDecorationPainter = baseDecorationPainter;
    }

    public void setTextureAlpha(float textureAlpha) {
        this.textureAlpha = textureAlpha;
    }

    public void setPaintingSeparators(boolean isPaintingSeparators) {
        this.isPaintingSeparators = isPaintingSeparators;
    }

    protected synchronized Image getColorizedTile(SubstanceTheme theme) {
        Image result = this.colorizedTileMap.get(theme.getDisplayName());
        if (result == null) {
            BufferedImage tileBi = new BufferedImage(this.originalTile.getWidth(null), this.originalTile.getHeight(null), 2);
            tileBi.getGraphics().drawImage(this.originalTile, 0, 0, null);
            result = SubstanceImageCreator.getThemeImage(tileBi, theme, false);
            this.colorizedTileMap.put(theme.getDisplayName(), result);
        }
        return result;
    }
}

