/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ClassicDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Classic";
    protected static Map<String, BufferedImage> smallImageCache = new SoftHashMap<String, BufferedImage>();
    protected ClassicGradientPainter painter = new ClassicGradientPainter();

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceTheme theme) {
        int size = Math.max(width, height);
        if (size < 150) {
            ClassicDecorationPainter classicDecorationPainter = this;
            synchronized (classicDecorationPainter) {
                String key = width + "*" + height + "*" + theme.getDisplayName();
                BufferedImage result = smallImageCache.get(key);
                if (result == null) {
                    result = SubstanceCoreUtilities.getBlankImage(width, height);
                    this.internalPaint((Graphics2D)result.getGraphics(), width, height, theme);
                    smallImageCache.put(key, result);
                }
                graphics.drawImage((Image)result, 0, 0, null);
                return;
            }
        }
        this.internalPaint(graphics, width, height, theme);
    }

    protected void internalPaint(Graphics2D graphics, int width, int height, SubstanceTheme theme) {
        graphics.setColor(theme.getActiveTitlePaneTheme().getColorScheme().getMidColor());
        graphics.drawImage((Image)this.painter.getContourBackground(width + 6, height + 6, new Rectangle(width + 6, height + 6), false, theme.getActiveTitlePaneTheme().getColorScheme(), theme.getActiveTitlePaneTheme().getColorScheme(), 0.0f, false, false), -3, -3, null);
    }

    public static synchronized void reset() {
        smallImageCache.clear();
    }
}

