/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.layer;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.swinghelper.layer.JXGlassPane;
import org.jdesktop.swinghelper.layer.LayerLayout;
import org.jdesktop.swinghelper.layer.item.LayerItemEvent;
import org.jdesktop.swinghelper.layer.item.LayerItemListener;
import org.jdesktop.swinghelper.layer.painter.DefaultPainter;
import org.jdesktop.swinghelper.layer.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLayer<V extends JComponent>
extends JComponent {
    public V view;
    private JComponent glassPane;
    public Painter<V> painter;
    private boolean isPainting;
    private LayerItemListener itemListener;
    private final FocusTraversalPolicy disabledPolicy = new LayoutFocusTraversalPolicy(){

        protected boolean accept(Component component) {
            return component == JXLayer.this.getGlassPane();
        }
    };
    private static final FocusListener glassPaneFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            e.getComponent().repaint();
        }

        public void focusLost(FocusEvent e) {
        }
    };
    private static final MouseListener emptyMouseListener = new MouseAdapter(){};
    private Component recentFocusOwner;
    private boolean enabled = true;

    public JXLayer() {
        this((JComponent)null);
    }

    public JXLayer(V view) {
        this(view, new DefaultPainter());
    }

    public JXLayer(Painter<V> painter) {
        this(null, painter);
    }

    public JXLayer(V view, Painter<V> painter) {
        this.itemListener = this.createLayerItemListener();
        this.setView(view);
        this.setPainter(painter);
        this.setGlassPane(new JXGlassPane());
        this.setLayout(LayerLayout.getSharedInstance());
        this.setPainter(painter);
        this.setOpaque(true);
        this.setFocusTraversalPolicy(this.disabledPolicy);
    }

    public V getView() {
        return this.view;
    }

    public void setView(V view) {
        V oldView = this.getView();
        if (oldView != null) {
            super.remove((Component)oldView);
        }
        if (view != null) {
            super.addImpl((Component)view, null, this.getComponentCount());
        }
        this.view = view;
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JComponent glassPane) {
        if (glassPane == null) {
            throw new IllegalArgumentException("GlassPane can't be set to null");
        }
        JComponent oldGlassPane = this.getGlassPane();
        if (oldGlassPane != null) {
            super.remove(oldGlassPane);
            oldGlassPane.removeFocusListener(glassPaneFocusListener);
        }
        super.addImpl(glassPane, null, 0);
        glassPane.addFocusListener(glassPaneFocusListener);
        this.glassPane = glassPane;
    }

    public Painter<V> getPainter() {
        return this.painter;
    }

    public void setPainter(Painter<V> painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Null painter is not supported; set DefaultPainter");
        }
        Painter<V> oldPainter = this.getPainter();
        if (painter != oldPainter) {
            if (oldPainter != null) {
                oldPainter.removeLayerItemListener(this.itemListener);
            }
            painter.addLayerItemListener(this.itemListener);
        }
        this.painter = painter;
        this.repaint();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException("JXLayer.add() is not supported; use setView() instead");
    }

    @Override
    public void remove(Component comp) {
        if (comp == this.getView()) {
            this.view = null;
        } else if (comp == this.getGlassPane()) {
            throw new IllegalArgumentException("GlassPane can't be removed");
        }
        super.remove(comp);
    }

    @Override
    public void removeAll() {
        this.setView(null);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isPainting && this.painter.isEnabled() && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g.create();
            this.isPainting = true;
            this.painter.paint(g2, this);
            this.isPainting = false;
            g2.dispose();
        } else {
            super.paint(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void setBorder(Border border) {
        throw new UnsupportedOperationException("JXLayer.setBorder() is not supported");
    }

    @Override
    public boolean contains(int x, int y) {
        Painter<V> painter = this.getPainter();
        if (painter != null && painter.isEnabled()) {
            return super.contains(x, y) && painter.contains(x, y, this);
        }
        return super.contains(x, y);
    }

    private LayerItemListener createLayerItemListener() {
        return new LayerItemListener(){

            public void layerItemChanged(LayerItemEvent e) {
                Rectangle clipBounds;
                Rectangle rectangle = clipBounds = e.getClip() == null ? new Rectangle(JXLayer.this.getSize()) : e.getClip().getBounds();
                if (JXLayer.this.view != null) {
                    ((Component)JXLayer.this.view).repaint(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                } else {
                    JXLayer.this.repaint(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                }
            }
        };
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.isEnabled();
        if (enabled != oldEnabled) {
            if (enabled) {
                this.getGlassPane().removeMouseListener(emptyMouseListener);
                this.setFocusTraversalPolicyProvider(false);
                boolean isGlassPaneFocused = this.getGlassPane().isFocusOwner();
                if (isGlassPaneFocused && this.recentFocusOwner != null) {
                    this.recentFocusOwner.requestFocusInWindow();
                }
                this.recentFocusOwner = null;
            } else {
                this.getGlassPane().addMouseListener(emptyMouseListener);
                this.setFocusTraversalPolicyProvider(true);
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focusOwner = kfm.getFocusOwner();
                if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this)) {
                    this.recentFocusOwner = focusOwner;
                    this.getGlassPane().requestFocusInWindow();
                }
            }
            this.enabled = enabled;
            this.firePropertyChange("enabled", oldEnabled, enabled);
            this.repaint();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

