/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import javax.swing.SizeSequence;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;

public class SizeSequenceMapper {
    private SizeSequence viewSizes;
    private SizeSequence modelSizes;
    private FilterPipeline pipeline;
    private PipelineListener pipelineListener;
    private int defaultHeight;

    public SizeSequenceMapper() {
    }

    public SizeSequenceMapper(FilterPipeline filterPipeline) {
        this();
        this.setFilters(filterPipeline);
    }

    public SizeSequenceMapper(FilterPipeline filterPipeline, SizeSequence sizeSequence, int n) {
        this();
        this.setViewSizeSequence(sizeSequence, n);
        this.setFilters(filterPipeline);
    }

    public void setViewSizeSequence(SizeSequence sizeSequence, int n) {
        SizeSequence sizeSequence2 = this.viewSizes;
        if (sizeSequence2 != null) {
            this.clearModelSizes();
        }
        this.viewSizes = sizeSequence;
        this.defaultHeight = n;
        this.mapTowardsModel();
    }

    public SizeSequence getViewSizeSequence() {
        return this.viewSizes;
    }

    public void setFilters(FilterPipeline filterPipeline) {
        FilterPipeline filterPipeline2 = this.pipeline;
        if (filterPipeline2 != null) {
            filterPipeline2.removePipelineListener(this.pipelineListener);
        }
        this.pipeline = filterPipeline;
        if (filterPipeline != null) {
            filterPipeline.addPipelineListener(this.getPipelineListener());
        }
        this.restoreSelection();
    }

    public void clearModelSizes() {
        this.modelSizes = null;
    }

    public void insertIndexInterval(int n, int n2, int n3) {
        if (this.modelSizes == null) {
            return;
        }
        this.modelSizes.insertEntries(n, n2, n3);
    }

    public void removeIndexInterval(int n, int n2) {
        if (this.modelSizes == null) {
            return;
        }
        this.modelSizes.removeEntries(n, n2);
    }

    public void restoreSelection() {
        if (this.viewSizes == null) {
            return;
        }
        this.viewSizes.setSizes(new int[0]);
        this.viewSizes.insertEntries(0, this.getOutputSize(), this.defaultHeight);
        int[] nArray = this.modelSizes.getSizes();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.convertToView(i);
            this.viewSizes.setSize(n, nArray[i]);
        }
    }

    private void mapTowardsModel() {
        if (this.viewSizes == null) {
            return;
        }
        this.modelSizes = new SizeSequence(this.getInputSize(), this.defaultHeight);
        int[] nArray = this.viewSizes.getSizes();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.convertToModel(i);
            this.modelSizes.setSize(n, nArray[i]);
        }
    }

    private int getInputSize() {
        return this.pipeline != null ? this.pipeline.getInputSize() : 0;
    }

    private int getOutputSize() {
        return this.pipeline != null ? this.pipeline.getOutputSize() : 0;
    }

    private int convertToModel(int n) {
        return this.pipeline != null ? this.pipeline.convertRowIndexToModel(n) : n;
    }

    private int convertToView(int n) {
        return this.pipeline != null ? this.pipeline.convertRowIndexToView(n) : n;
    }

    protected void updateFromPipelineChanged() {
        this.restoreSelection();
    }

    private PipelineListener getPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = new PipelineListener(){

                public void contentsChanged(PipelineEvent pipelineEvent) {
                    SizeSequenceMapper.this.updateFromPipelineChanged();
                }
            };
        }
        return this.pipelineListener;
    }
}

