/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.DateUtils;

public class JXMonthView
extends JComponent {
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int WEEK_SELECTION = 3;
    public static final int MONTH_DOWN = 1;
    public static final int MONTH_UP = 2;
    protected static final SimpleDateFormat _dayOfMonthFormatter = new SimpleDateFormat("d");
    protected Insets _monthStringInsets = new Insets(0, 0, 0, 0);
    private static final int MONTH_DROP_SHADOW = 1;
    private static final int MONTH_LINE_DROP_SHADOW = 2;
    private static final int WEEK_DROP_SHADOW = 4;
    private int _boxPaddingX = 3;
    private int _boxPaddingY = 3;
    private int _arrowPaddingX = 3;
    private int _arrowPaddingY = 3;
    private static final int CALENDAR_SPACING = 10;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MONTHS_IN_YEAR = 12;
    private long _firstDisplayedDate;
    private int _firstDisplayedMonth;
    private int _firstDisplayedYear;
    private long _lastDisplayedDate;
    private Font _derivedFont;
    private long _startSelectedDate = -1L;
    private long _endSelectedDate = -1L;
    private long _pivotDate = -1L;
    private int _numCalCols = 1;
    private int _numCalRows = 1;
    private int _minCalCols = 1;
    private int _minCalRows = 1;
    private long _today;
    private HashSet<Long> _flaggedDates;
    private int _selectionMode = 1;
    private int _boxHeight;
    private int _boxWidth;
    private int _monthBoxHeight;
    private int _calendarWidth;
    private int _calendarHeight;
    private int _firstDayOfWeek = 1;
    private int _startX;
    private int _startY;
    private int _dropShadowMask = 0;
    private boolean _dirty = false;
    private boolean _antiAlias = false;
    private boolean _ltr;
    private boolean _traversable = false;
    private boolean _usingKeyboard = false;
    private boolean _asKirkWouldSay_FIRE = false;
    private Calendar _cal;
    private String[] _daysOfTheWeek;
    private static String[] _monthsOfTheYear;
    private Dimension _dim = new Dimension();
    private Rectangle _bounds = new Rectangle();
    private Rectangle _dirtyRect = new Rectangle();
    private Color _todayBackgroundColor;
    private Color _monthStringBackground;
    private Color _monthStringForeground;
    private Color _daysOfTheWeekForeground;
    private Color _selectedBackground;
    private String _actionCommand = "selectionChanged";
    private Timer _todayTimer = null;
    private ImageIcon _monthDownImage;
    private ImageIcon _monthUpImage;
    private Hashtable<Integer, Color> _dayToColorTable = new Hashtable();
    private DateSpan _originalDateSpan = null;

    public JXMonthView() {
        this(new Date().getTime());
    }

    public JXMonthView(long l) {
        this._ltr = this.getComponentOrientation().isLeftToRight();
        this._cal = Calendar.getInstance(this.getLocale());
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this._cal.setMinimalDaysInFirstWeek(1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(l);
        this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        _monthsOfTheYear = new DateFormatSymbols().getMonths();
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this._todayBackgroundColor = this.getForeground();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.enableEvents(16L);
        this.enableEvents(32L);
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "addPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "addNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "addToPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "addToNextWeek");
        inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "addPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "addNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "addToPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "addToNextWeek");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("acceptSelection", new KeyboardAction(0));
        actionMap.put("cancelSelection", new KeyboardAction(1));
        actionMap.put("selectPreviousDay", new KeyboardAction(2));
        actionMap.put("selectNextDay", new KeyboardAction(3));
        actionMap.put("selectDayInPreviousWeek", new KeyboardAction(4));
        actionMap.put("selectDayInNextWeek", new KeyboardAction(5));
        actionMap.put("addPreviousDay", new KeyboardAction(6));
        actionMap.put("addNextDay", new KeyboardAction(7));
        actionMap.put("addToPreviousWeek", new KeyboardAction(8));
        actionMap.put("addToNextWeek", new KeyboardAction(9));
        this.updateUI();
    }

    public void updateUI() {
        Object object;
        super.updateUI();
        String[] stringArray = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (stringArray == null) {
            object = new DateFormatSymbols().getShortWeekdays();
            stringArray = new String[7];
            for (int i = 1; i <= 7; ++i) {
                stringArray[i - 1] = object[i];
            }
        }
        this.setDaysOfTheWeek(stringArray);
        object = UIManager.getColor("JXMonthView.monthStringBackground");
        if (object == null) {
            object = new Color(138, 173, 209);
        }
        this.setMonthStringBackground((Color)object);
        object = UIManager.getColor("JXMonthView.monthStringForeground");
        if (object == null) {
            object = new Color(68, 68, 68);
        }
        this.setMonthStringForeground((Color)object);
        object = UIManager.getColor("JXMonthView.daysOfTheWeekForeground");
        if (object == null) {
            object = new Color(68, 68, 68);
        }
        this.setDaysOfTheWeekForeground((Color)object);
        object = UIManager.getColor("JXMonthView.selectedBackground");
        if (object == null) {
            object = new Color(197, 220, 240);
        }
        this.setSelectedBackground((Color)object);
        Font font = UIManager.getFont("JXMonthView.font");
        if (font == null) {
            font = UIManager.getFont("Button.font");
        }
        this.setFont(font);
        String string = UIManager.getString("JXMonthView.monthDownFileName");
        if (string == null) {
            string = "resources/month-down.png";
        }
        this._monthDownImage = new ImageIcon(JXMonthView.class.getResource(string));
        string = UIManager.getString("JXMonthView.monthUpFileName");
        if (string == null) {
            string = "resources/month-up.png";
        }
        this._monthUpImage = new ImageIcon(JXMonthView.class.getResource(string));
    }

    public long getFirstDisplayedDate() {
        return this._firstDisplayedDate;
    }

    public void setFirstDisplayedDate(long l) {
        long l2 = this._firstDisplayedDate;
        this._cal.setTimeInMillis(l);
        this._cal.set(5, 1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._firstDisplayedDate = this._cal.getTimeInMillis();
        this._firstDisplayedMonth = this._cal.get(2);
        this._firstDisplayedYear = this._cal.get(1);
        this.calculateLastDisplayedDate();
        this.firePropertyChange("firstDisplayedDate", l2, this._firstDisplayedDate);
        this.repaint();
    }

    public long getLastDisplayedDate() {
        return this._lastDisplayedDate;
    }

    private void calculateLastDisplayedDate() {
        long l = this._lastDisplayedDate;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, this._numCalCols * this._numCalRows - 1);
        this._cal.set(5, this._cal.getActualMaximum(5));
        this._cal.set(11, 23);
        this._cal.set(12, 59);
        this._cal.set(13, 59);
        this._lastDisplayedDate = this._cal.getTimeInMillis();
        this.firePropertyChange("lastDisplayedDate", l, this._lastDisplayedDate);
    }

    public void ensureDateVisible(long l) {
        if (l < this._firstDisplayedDate) {
            this.setFirstDisplayedDate(l);
        } else if (l > this._lastDisplayedDate) {
            this._cal.setTimeInMillis(l);
            int n = this._cal.get(2);
            int n2 = this._cal.get(1);
            this._cal.setTimeInMillis(this._lastDisplayedDate);
            int n3 = this._cal.get(2);
            int n4 = this._cal.get(1);
            int n5 = n - n3 + (n2 - n4) * 12;
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this._cal.add(2, n5);
            this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        }
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            this.calculateDirtyRectForSelection();
        }
    }

    public DateSpan getSelectedDateSpan() {
        DateSpan dateSpan = null;
        if (this._startSelectedDate != -1L) {
            dateSpan = new DateSpan(new Date(this._startSelectedDate), new Date(this._endSelectedDate));
        }
        return dateSpan;
    }

    public void setSelectedDateSpan(DateSpan dateSpan) {
        DateSpan dateSpan2 = null;
        if (this._startSelectedDate != -1L && this._endSelectedDate != -1L) {
            dateSpan2 = new DateSpan(this._startSelectedDate, this._endSelectedDate);
        }
        if (dateSpan == null) {
            this._startSelectedDate = -1L;
            this._endSelectedDate = -1L;
        } else {
            this._cal.setTimeInMillis(dateSpan.getStart());
            this._cal.set(11, 0);
            this._cal.set(12, 0);
            this._cal.set(13, 0);
            this._cal.set(14, 0);
            this._startSelectedDate = this._cal.getTimeInMillis();
            if (this._selectionMode == 1) {
                this._endSelectedDate = this._startSelectedDate;
            } else {
                this._cal.setTimeInMillis(dateSpan.getEnd());
                this._cal.set(11, 0);
                this._cal.set(12, 0);
                this._cal.set(13, 0);
                this._cal.set(14, 0);
                this._endSelectedDate = this._cal.getTimeInMillis();
                if (this._selectionMode == 3) {
                    this._cal.setTimeInMillis(this._startSelectedDate);
                    int n = 1;
                    while (this._cal.getTimeInMillis() < this._endSelectedDate) {
                        this._cal.add(5, 1);
                        ++n;
                    }
                    if (n > 7) {
                        int n2;
                        this._cal.setTimeInMillis(this._startSelectedDate);
                        int n3 = this._cal.get(7);
                        if (n3 != this._firstDayOfWeek) {
                            n2 = n3 - this._firstDayOfWeek;
                            if (n2 < 0) {
                                n2 += 7;
                            }
                            this._cal.add(5, -n2);
                            n += n2;
                            this._startSelectedDate = this._cal.getTimeInMillis();
                        }
                        if ((n2 = n % 7) != 0) {
                            this._cal.setTimeInMillis(this._endSelectedDate);
                            this._cal.add(5, 7 - n2);
                            this._endSelectedDate = this._cal.getTimeInMillis();
                        }
                    }
                }
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
        this.repaint(this._dirtyRect);
        this.calculateDirtyRectForSelection();
        this.repaint(this._dirtyRect);
        this.firePropertyChange("selectedDates", dateSpan2, dateSpan);
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public void setSelectionMode(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2 && n != 3 && n != 0) {
            throw new IllegalArgumentException(n + " is not a valid selection mode");
        }
        this._selectionMode = n;
    }

    protected boolean isFlaggedDate(long l) {
        boolean bl = false;
        if (this._flaggedDates != null) {
            bl = this._flaggedDates.contains(l);
        }
        return bl;
    }

    public void setFlaggedDates(long[] lArray) {
        if (this._flaggedDates == null) {
            this._flaggedDates = null;
        } else {
            this._flaggedDates = new HashSet();
            for (long l : lArray) {
                this._cal.setTimeInMillis(l);
                this._cal.set(11, 0);
                this._cal.set(12, 0);
                this._cal.set(13, 0);
                this._cal.set(14, 0);
                this._flaggedDates.add(this._cal.getTimeInMillis());
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
        this.repaint();
    }

    public int getBoxPaddingX() {
        return this._boxPaddingX;
    }

    public void setBoxPaddingX(int n) {
        this._boxPaddingX = n;
        this._dirty = true;
    }

    public int getBoxPaddingY() {
        return this._boxPaddingY;
    }

    public void setBoxPaddingY(int n) {
        this._boxPaddingY = n;
        this._dirty = true;
    }

    public boolean getTraversable() {
        return this._traversable;
    }

    public void setTraversable(boolean bl) {
        this._traversable = bl;
        this._dirty = true;
        this.repaint();
    }

    public void setDaysOfTheWeek(String[] stringArray) throws IllegalArgumentException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("Array of days is null.");
        }
        if (stringArray.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        this._daysOfTheWeek = stringArray;
        this._dirty = true;
        this.repaint();
    }

    public String[] getDaysOfTheWeek() {
        String[] stringArray = new String[7];
        System.arraycopy(this._daysOfTheWeek, 0, stringArray, 0, 7);
        return stringArray;
    }

    public int getFirstDayOfWeek() {
        return this._firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int n) {
        if (n == this._firstDayOfWeek) {
            return;
        }
        this._firstDayOfWeek = n;
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this.repaint();
    }

    public TimeZone getTimeZone() {
        return this._cal.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this._cal.setTimeZone(timeZone);
    }

    public boolean getAntialiased() {
        return this._antiAlias;
    }

    public void setAntialiased(boolean bl) {
        if (this._antiAlias == bl) {
            return;
        }
        this._antiAlias = bl;
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this._selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        this._selectedBackground = color;
    }

    public Color getTodayBackground() {
        return this._todayBackgroundColor;
    }

    public void setTodayBackground(Color color) {
        this._todayBackgroundColor = color;
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this._monthStringBackground;
    }

    public void setMonthStringBackground(Color color) {
        this._monthStringBackground = color;
        this.repaint();
    }

    public Color getMonthStringForeground() {
        return this._monthStringForeground;
    }

    public void setMonthStringForeground(Color color) {
        this._monthStringForeground = color;
        this.repaint();
    }

    public void setDaysOfTheWeekForeground(Color color) {
        this._daysOfTheWeekForeground = color;
        this.repaint();
    }

    public Color getDaysOfTheWeekForeground() {
        return this._daysOfTheWeekForeground;
    }

    public void setDayForeground(int n, Color color) {
        this._dayToColorTable.put(n, color);
    }

    public Color getDayForeground(int n) {
        Color color = this._dayToColorTable.get(n);
        if (color == null) {
            color = this.getForeground();
        }
        return color;
    }

    protected int getDayOfTheWeek() {
        return this._cal.get(7);
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.repaint();
    }

    public int getPreferredCols() {
        return this._minCalCols;
    }

    public void setPreferredCols(int n) {
        if (n <= 0) {
            return;
        }
        this._minCalCols = n;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRows() {
        return this._minCalRows;
    }

    public void setPreferredRows(int n) {
        if (n <= 0) {
            return;
        }
        this._minCalRows = n;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    private void updateIfNecessary() {
        if (this._dirty) {
            this.update();
            this._dirty = false;
        }
    }

    private void update() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this._derivedFont = this.getFont().deriveFont(1);
        FontMetrics fontMetrics = this.getFontMetrics(this._derivedFont);
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        for (int i = 0; i < this._cal.getMaximum(2); ++i) {
            int n6;
            n2 = fontMetrics.stringWidth(_monthsOfTheYear[i]);
            if (n2 > n5) {
                n5 = n2;
            }
            if ((n6 = this._cal.getActualMaximum(5)) > n4) {
                n3 = this._cal.get(2);
                n4 = n6;
            }
            this._cal.add(2, 1);
        }
        this._boxHeight = fontMetrics.getHeight();
        for (String string : this._daysOfTheWeek) {
            n2 = fontMetrics.stringWidth(string);
            if (n2 <= this._boxWidth) continue;
            this._boxWidth = n2;
        }
        this._cal.set(2, n3);
        this._cal.set(5, this._cal.getActualMinimum(5));
        for (n = 0; n < n4; ++n) {
            n2 = fontMetrics.stringWidth(_dayOfMonthFormatter.format(this._cal.getTime()));
            if (n2 > this._boxWidth) {
                this._boxWidth = n2;
            }
            this._cal.add(5, 1);
        }
        this._monthBoxHeight = this._boxHeight;
        if (this._traversable && (n = this._monthDownImage.getIconHeight() + this._arrowPaddingY + this._arrowPaddingY) > this._monthBoxHeight) {
            this._monthBoxHeight = n;
        }
        this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        if (this._dim.width < n5) {
            double d = n5 - this._dim.width;
            if (this._traversable) {
                d += (double)(this._monthDownImage.getIconWidth() + this._monthUpImage.getIconWidth() + this._arrowPaddingX * 4);
            }
            this._boxWidth = (int)((double)this._boxWidth + Math.ceil(d / 7.0));
            this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        }
        this._calendarWidth = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        this._calendarHeight = (this._boxPaddingY + this._boxHeight + this._boxPaddingY) * 7 + (this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY);
        this._dim.height = this._calendarHeight * this._minCalRows + 10 * (this._minCalRows - 1);
        this._dim.width = this._calendarWidth * this._minCalCols + 10 * (this._minCalCols - 1);
        Insets insets = this.getInsets();
        this._dim.width += insets.left + insets.right;
        this._dim.height += insets.top + insets.bottom;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            if (this._startSelectedDate > this._lastDisplayedDate || this._startSelectedDate < this._firstDisplayedDate) {
                this.ensureDateVisible(this._startSelectedDate);
            } else {
                this.calculateDirtyRectForSelection();
            }
        }
    }

    private void updateToday() {
        this._cal.setTimeInMillis(this._today);
        this._cal.add(5, 1);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        this.updateIfNecessary();
        return new Dimension(this._dim);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this._dirty = true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this._dirty = true;
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this._ltr = componentOrientation.isLeftToRight();
        this.calculateStartPosition();
        this.calculateDirtyRectForSelection();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._dirty = true;
    }

    public void removeNotify() {
        this._todayTimer.stop();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        int n = 86400;
        if (this._todayTimer == null) {
            this._todayTimer = new Timer(n * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JXMonthView.this.updateToday();
                }
            });
        }
        this._cal.setTimeInMillis(System.currentTimeMillis());
        n = n - this._cal.get(11) * 3600 - this._cal.get(12) * 60 - this._cal.get(13);
        this._todayTimer.setInitialDelay(n * 1000);
        this._todayTimer.start();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D;
        Object object = null;
        Graphics2D graphics2D2 = graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D != null && this._antiAlias) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle rectangle = graphics.getClipBounds();
        this.updateIfNecessary();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(this.getForeground());
        Color color = graphics.getColor();
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        int n = this._startY;
        for (int i = 0; i < this._numCalRows; ++i) {
            int n2 = this._startX;
            this._bounds.x = 0;
            this._bounds.y = this._startY + i * (this._calendarHeight + 10);
            this._bounds.width = this.getWidth();
            this._bounds.height = this._calendarHeight;
            if (!this._bounds.intersects(rectangle)) {
                this._cal.add(2, this._numCalCols);
                n += this._calendarHeight + 10;
                continue;
            }
            for (int j = 0; j < this._numCalCols; ++j) {
                Serializable serializable;
                int n3;
                int n4;
                String string = _monthsOfTheYear[this._cal.get(2)];
                string = string + " " + this._cal.get(1);
                this._bounds.x = this._ltr ? n2 : n2 - this._calendarWidth;
                this._bounds.y = n + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._monthBoxHeight;
                if (this._bounds.intersects(rectangle)) {
                    this.paintMonthStringBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    if (this._traversable) {
                        n4 = this._bounds.x + this._arrowPaddingX;
                        n3 = this._bounds.y + (this._bounds.height - this._monthDownImage.getIconHeight()) / 2;
                        graphics.drawImage(this._monthDownImage.getImage(), n4, n3, null);
                        n4 = this._bounds.x + this._bounds.width - this._arrowPaddingX - this._monthUpImage.getIconWidth();
                        graphics.drawImage(this._monthUpImage.getImage(), n4, n3, null);
                    }
                    Font font = this.getFont();
                    serializable = fontMetrics;
                    graphics.setFont(this._derivedFont);
                    fontMetrics = this.getFontMetrics(this._derivedFont);
                    graphics.setColor(this._monthStringForeground);
                    n4 = this._ltr ? n2 + this._calendarWidth / 2 - fontMetrics.stringWidth(string) / 2 : n2 - this._calendarWidth / 2 - fontMetrics.stringWidth(string) / 2 - 1;
                    n3 = this._bounds.y + (this._monthBoxHeight - this._boxHeight) / 2 + fontMetrics.getAscent();
                    if ((this._dropShadowMask & 1) != 0) {
                        graphics.setColor(color);
                        graphics.drawString(string, n4 + 1, n3 + 1);
                        graphics.setColor(this._monthStringForeground);
                    }
                    graphics.drawString(string, n4, n3);
                    graphics.setFont(font);
                    fontMetrics = serializable;
                }
                graphics.setColor(this.getDaysOfTheWeekForeground());
                this._bounds.x = this._ltr ? n2 : n2 - this._calendarWidth;
                this._bounds.y = n + this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY + this._boxPaddingY;
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._boxHeight;
                if (this._bounds.intersects(rectangle)) {
                    this._cal.set(5, this._cal.getActualMinimum(5));
                    int n5 = this._firstDayOfWeek - 1;
                    serializable = graphics.getFont();
                    FontMetrics fontMetrics2 = fontMetrics;
                    graphics.setFont(this._derivedFont);
                    fontMetrics = this.getFontMetrics(this._derivedFont);
                    for (int k = 0; k < 7; ++k) {
                        n4 = this._ltr ? n2 + k * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) + this._boxPaddingX + this._boxWidth / 2 - fontMetrics.stringWidth(this._daysOfTheWeek[n5]) / 2 : n2 - k * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) - this._boxPaddingX - this._boxWidth / 2 - fontMetrics.stringWidth(this._daysOfTheWeek[n5]) / 2;
                        n3 = this._bounds.y + fontMetrics.getAscent();
                        if ((this._dropShadowMask & 4) != 0) {
                            graphics.setColor(color);
                            graphics.drawString(this._daysOfTheWeek[n5], n4 + 1, n3 + 1);
                            graphics.setColor(this.getDaysOfTheWeekForeground());
                        }
                        graphics.drawString(this._daysOfTheWeek[n5], n4, n3);
                        if (++n5 != 7) continue;
                        n5 = 0;
                    }
                    graphics.setFont((Font)serializable);
                    fontMetrics = fontMetrics2;
                }
                this._bounds.x = this._startX + (this._ltr ? j * (this._calendarWidth + 10) : -(j * (this._calendarWidth + 10) + this._calendarWidth));
                this._bounds.y = this._startY + i * (this._calendarHeight + 10);
                this._bounds.width = this._calendarWidth;
                this._bounds.height = this._calendarHeight;
                if (this._bounds.intersects(rectangle)) {
                    this.paintMonth(graphics);
                } else {
                    this._cal.add(2, 1);
                }
                n2 += this._ltr ? this._calendarWidth + 10 : -(this._calendarWidth + 10);
            }
            n += this._calendarHeight + 10;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        if (graphics2D != null && this._antiAlias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    private void paintMonth(Graphics graphics) {
        int n = this._cal.getActualMaximum(5);
        Rectangle rectangle = graphics.getClipBounds();
        for (int i = 0; i < n; ++i) {
            this.calculateBoundsForDay(this._bounds);
            if (this._bounds.intersects(rectangle)) {
                long l = this._cal.getTimeInMillis();
                if (this.isSelectedDate(l) && this._selectionMode == 1) {
                    this._dirtyRect.x = this._bounds.x;
                    this._dirtyRect.y = this._bounds.y;
                    this._dirtyRect.width = this._bounds.width;
                    this._dirtyRect.height = this._bounds.height;
                }
                this.paintDayBackground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height, l);
                this.paintDayForeground(graphics, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height, l);
            }
            this._cal.add(5, 1);
        }
    }

    protected void paintMonthStringBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this._ltr ? n + this._monthStringInsets.left : n + this._monthStringInsets.right;
        n3 = n3 - this._monthStringInsets.left - this._monthStringInsets.right;
        n4 = n4 - this._monthStringInsets.top - this._monthStringInsets.bottom;
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = new GradientPaint(n, (n2 += this._monthStringInsets.top) + n4, new Color(238, 238, 238), n, n2, new Color(204, 204, 204));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2, n3 - 1, n4 - 1);
        graphics2D.setPaint(new Color(153, 153, 153));
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    protected void paintDayBackground(Graphics graphics, int n, int n2, int n3, int n4, long l) {
        if (this.isSelectedDate(l)) {
            graphics.setColor(this.getSelectedBackground());
            graphics.fillRect(n, n2, n3, n4);
        }
        if (this.isToday(l)) {
            GradientPaint gradientPaint = new GradientPaint(n, n2, new Color(91, 123, 145), n, n2 + n4, new Color(68, 86, 98));
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint);
            graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    protected void paintDayForeground(Graphics graphics, int n, int n2, int n3, int n4, long l) {
        String string = _dayOfMonthFormatter.format(l);
        graphics.setColor(this.getDayForeground(this.getDayOfTheWeek()));
        if (this.isFlaggedDate(l)) {
            Font font = this.getFont();
            graphics.setFont(this._derivedFont);
            FontMetrics fontMetrics = this.getFontMetrics(this._derivedFont);
            graphics.drawString(string, this._ltr ? n + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) : n + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) - 1, n2 + this._boxPaddingY + fontMetrics.getAscent());
            graphics.setFont(font);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(string, this._ltr ? n + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) : n + this._boxPaddingX + this._boxWidth - fontMetrics.stringWidth(string) - 1, n2 + this._boxPaddingY + fontMetrics.getAscent());
        }
    }

    protected boolean isSelectedDate(long l) {
        return l >= this._startSelectedDate && l <= this._endSelectedDate;
    }

    protected boolean isToday(long l) {
        return l == this._today;
    }

    private void calculateNumDisplayedCals() {
        int n = this._numCalCols;
        int n2 = this._numCalRows;
        this._numCalCols = 1;
        this._numCalCols += (this.getWidth() - this._calendarWidth) / (this._calendarWidth + 10);
        this._numCalRows = 1;
        this._numCalRows += (this.getHeight() - this._calendarHeight) / (this._calendarHeight + 10);
        if (n != this._numCalCols || n2 != this._numCalRows) {
            this.calculateLastDisplayedDate();
        }
    }

    private void calculateStartPosition() {
        this._startX = (this.getWidth() - (this._calendarWidth * this._numCalCols + 10 * (this._numCalCols - 1))) / 2;
        if (!this._ltr) {
            this._startX = this.getWidth() - this._startX;
        }
        this._startY = (this.getHeight() - (this._calendarHeight * this._numCalRows + 10 * (this._numCalRows - 1))) / 2;
    }

    private void calculateBoundsForDay(Rectangle rectangle) {
        int n = this._cal.get(1);
        int n2 = this._cal.get(2);
        int n3 = this._cal.get(7);
        int n4 = this._cal.get(4);
        int n5 = n2 - this._firstDisplayedMonth + (n - this._firstDisplayedYear) * 12;
        int n6 = n5 / this._numCalCols;
        int n7 = n5 - n6 * this._numCalCols;
        rectangle.x = n3 - this._firstDayOfWeek;
        if (rectangle.x < 0) {
            rectangle.x += 7;
        }
        rectangle.x = this._ltr ? rectangle.x * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) : (rectangle.x + 1) * (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        rectangle.x += n7 * (this._calendarWidth + 10);
        rectangle.x = this._ltr ? this._startX + rectangle.x : this._startX - rectangle.x;
        rectangle.y = this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY + this._boxPaddingY + this._boxHeight + this._boxPaddingY;
        rectangle.y += this._startY + n6 * (this._calendarHeight + 10);
        rectangle.y += (n4 - 1) * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        rectangle.width = this._boxPaddingX + this._boxWidth + this._boxPaddingX;
        rectangle.height = this._boxPaddingY + this._boxHeight + this._boxPaddingY;
    }

    public long getDayAt(int n, int n2) {
        int n3;
        if (this._ltr ? this._startX > n : this._startX < n || this._startY > n2) {
            return -1L;
        }
        int n4 = (this._ltr ? n - this._startX : this._startX - n) / (this._calendarWidth + 10);
        int n5 = (n2 - this._startY) / (this._calendarHeight + 10);
        if (n5 > this._numCalRows - 1 || n4 > this._numCalCols - 1) {
            return -1L;
        }
        int n6 = 1;
        n6 += (n2 - this._startY - n5 * (this._calendarHeight + 10) - (this._boxPaddingY + this._monthBoxHeight + this._boxPaddingY)) / (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        if ((n6 -= 2) < 0 || n6 > 5) {
            return -1L;
        }
        int n7 = ((this._ltr ? n - this._startX : this._startX - n) - n4 * (this._calendarWidth + 10)) / (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        if (n7 > 6) {
            return -1L;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, n4 + n5 * this._numCalCols);
        int n8 = this._cal.get(7);
        int n9 = n8 - this._firstDayOfWeek;
        if (n9 < 0) {
            n9 += 7;
        }
        if ((n3 = n6 * 7 + (n7 - n9)) < 0 || n3 > this._cal.getActualMaximum(5) - 1) {
            return -1L;
        }
        this._cal.add(5, n3);
        long l = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        return l;
    }

    protected int getTraversableButtonAt(int n, int n2) {
        if (this._ltr ? this._startX > n : this._startX < n || this._startY > n2) {
            return -1;
        }
        int n3 = (this._ltr ? n - this._startX : this._startX - n) / (this._calendarWidth + 10);
        int n4 = (n2 - this._startY) / (this._calendarHeight + 10);
        if (n4 > this._numCalRows - 1 || n3 > this._numCalCols - 1) {
            return -1;
        }
        if ((n2 = n2 - this._startY - n4 * (this._calendarHeight + 10) - this._boxPaddingY) < this._arrowPaddingY || n2 > this._monthBoxHeight - this._arrowPaddingY) {
            return -1;
        }
        n = (this._ltr ? n - this._startX : this._startX - n) - n3 * (this._calendarWidth + 10);
        if (n > this._arrowPaddingX && n < this._arrowPaddingX + this._monthDownImage.getIconWidth() + this._arrowPaddingX) {
            return 1;
        }
        if (n > this._calendarWidth - this._arrowPaddingX * 2 - this._monthUpImage.getIconWidth() && n < this._calendarWidth - this._arrowPaddingX) {
            return 2;
        }
        return -1;
    }

    private void calculateDirtyRectForSelection() {
        if (this._startSelectedDate == -1L || this._endSelectedDate == -1L) {
            this._dirtyRect.x = 0;
            this._dirtyRect.y = 0;
            this._dirtyRect.width = 0;
            this._dirtyRect.height = 0;
        } else {
            this._cal.setTimeInMillis(this._startSelectedDate);
            this.calculateBoundsForDay(this._dirtyRect);
            this._cal.add(5, 1);
            while (this._cal.getTimeInMillis() <= this._endSelectedDate) {
                this.calculateBoundsForDay(this._bounds);
                Rectangle rectangle = this._dirtyRect.union(this._bounds);
                this._dirtyRect.x = rectangle.x;
                this._dirtyRect.y = rectangle.y;
                this._dirtyRect.width = rectangle.width;
                this._dirtyRect.height = rectangle.height;
                this._cal.add(5, 1);
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String string) {
        this._actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this._actionCommand);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n;
        this._usingKeyboard = false;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasFocus() && this.isFocusable()) {
            this.requestFocusInWindow();
        }
        if ((n = mouseEvent.getID()) == 501 && this._traversable) {
            int n2 = this.getTraversableButtonAt(mouseEvent.getX(), mouseEvent.getY());
            if (n2 == 1) {
                this.setFirstDisplayedDate(DateUtils.getPreviousMonth(this.getFirstDisplayedDate()));
                return;
            }
            if (n2 == 2) {
                this.setFirstDisplayedDate(DateUtils.getNextMonth(this.getFirstDisplayedDate()));
                return;
            }
        }
        if (this._selectionMode == 0) {
            return;
        }
        if (n == 501) {
            long l = this.getDayAt(mouseEvent.getX(), mouseEvent.getY());
            if (l == -1L) {
                return;
            }
            this._startSelectedDate = l;
            this._endSelectedDate = l;
            if (this._selectionMode == 2 || this._selectionMode == 3) {
                this._pivotDate = l;
            }
            this._cal.setTimeInMillis(l);
            this.calculateBoundsForDay(this._bounds);
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this.repaint(this._dirtyRect);
            this.repaint(this._bounds);
            this._dirtyRect.x = this._bounds.x;
            this._dirtyRect.y = this._bounds.y;
            this._dirtyRect.width = this._bounds.width;
            this._dirtyRect.height = this._bounds.height;
            this._asKirkWouldSay_FIRE = true;
        } else if (n == 502) {
            if (this._asKirkWouldSay_FIRE) {
                this.fireActionPerformed();
            }
            this._asKirkWouldSay_FIRE = false;
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this._usingKeyboard = false;
        if (!this.isEnabled() || this._selectionMode == 0) {
            return;
        }
        int n = mouseEvent.getID();
        if (n == 506) {
            int n2;
            int n3 = mouseEvent.getX();
            long l = this.getDayAt(n3, n2 = mouseEvent.getY());
            if (l == -1L) {
                return;
            }
            long l2 = this._startSelectedDate;
            long l3 = this._endSelectedDate;
            if (this._selectionMode == 1) {
                if (l == l2) {
                    return;
                }
                this._startSelectedDate = l;
                this._endSelectedDate = l;
            } else if (l <= this._pivotDate) {
                this._startSelectedDate = l;
                this._endSelectedDate = this._pivotDate;
            } else if (l > this._pivotDate) {
                this._startSelectedDate = this._pivotDate;
                this._endSelectedDate = l;
            }
            if (this._selectionMode == 3) {
                long l4 = l > this._pivotDate ? this._pivotDate : l;
                long l5 = l > this._pivotDate ? l : this._pivotDate;
                this._cal.setTimeInMillis(l4);
                int n4 = 1;
                while (this._cal.getTimeInMillis() < l5) {
                    this._cal.add(5, 1);
                    ++n4;
                }
                if (n4 > 7) {
                    int n5;
                    this._cal.setTimeInMillis(l4);
                    int n6 = this._cal.get(7);
                    int n7 = n6 - this._firstDayOfWeek;
                    if (n7 < 0) {
                        n7 += 7;
                    }
                    this._cal.add(5, -n7);
                    this._startSelectedDate = this._cal.getTimeInMillis();
                    this._cal.setTimeInMillis(l5);
                    n6 = this._cal.get(7);
                    int n8 = this._firstDayOfWeek - 1;
                    if (n8 == 0) {
                        n8 = 7;
                    }
                    if ((n5 = n8 - n6) < 0) {
                        n5 += 7;
                    }
                    this._cal.add(5, n5);
                    this._endSelectedDate = this._cal.getTimeInMillis();
                }
            }
            if (l2 == this._startSelectedDate && l3 == this._endSelectedDate) {
                return;
            }
            this.repaint(this._dirtyRect);
            this.calculateDirtyRectForSelection();
            this.repaint(this._dirtyRect);
            this._asKirkWouldSay_FIRE = true;
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private class KeyboardAction
    extends AbstractAction {
        public static final int ACCEPT_SELECTION = 0;
        public static final int CANCEL_SELECTION = 1;
        public static final int SELECT_PREVIOUS_DAY = 2;
        public static final int SELECT_NEXT_DAY = 3;
        public static final int SELECT_DAY_PREVIOUS_WEEK = 4;
        public static final int SELECT_DAY_NEXT_WEEK = 5;
        public static final int ADD_PREVIOUS_DAY = 6;
        public static final int ADD_NEXT_DAY = 7;
        public static final int ADD_TO_PREVIOUS_WEEK = 8;
        public static final int ADD_TO_NEXT_WEEK = 9;
        private int action;

        public KeyboardAction(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JXMonthView.this.getSelectionMode();
            if (JXMonthView.this._startSelectedDate != -1L && n != 0) {
                if (!JXMonthView.this._usingKeyboard) {
                    JXMonthView.this._originalDateSpan = JXMonthView.this.getSelectedDateSpan();
                }
                if (this.action >= 0 && this.action <= 1 && JXMonthView.this._usingKeyboard) {
                    if (this.action == 1) {
                        JXMonthView.this.setSelectedDateSpan(JXMonthView.this._originalDateSpan);
                        JXMonthView.this.fireActionPerformed();
                    } else {
                        JXMonthView.this.setSelectedDateSpan(JXMonthView.this.getSelectedDateSpan());
                        JXMonthView.this.fireActionPerformed();
                    }
                    JXMonthView.this._usingKeyboard = false;
                } else if (this.action >= 2 && this.action <= 5) {
                    JXMonthView.this._usingKeyboard = true;
                    this.traverse(this.action);
                } else if (n >= 2 && this.action >= 6 && this.action <= 9) {
                    JXMonthView.this._usingKeyboard = true;
                    this.addToSelection(this.action);
                }
            }
        }

        private void traverse(int n) {
            JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._startSelectedDate);
            switch (n) {
                case 2: {
                    JXMonthView.this._cal.add(5, -1);
                    break;
                }
                case 3: {
                    JXMonthView.this._cal.add(5, 1);
                    break;
                }
                case 4: {
                    JXMonthView.this._cal.add(5, -7);
                    break;
                }
                case 5: {
                    JXMonthView.this._cal.add(5, 7);
                }
            }
            long l = JXMonthView.this._cal.getTimeInMillis();
            if (l != JXMonthView.this._startSelectedDate) {
                JXMonthView.this.setSelectedDateSpan(new DateSpan(l, l));
                JXMonthView.this.ensureDateVisible(l);
            }
            JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._firstDisplayedDate);
        }

        private void addToSelection(int n) {
            long l = JXMonthView.this._startSelectedDate;
            long l2 = JXMonthView.this._endSelectedDate;
            boolean bl = true;
            switch (n) {
                case 6: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._startSelectedDate);
                    JXMonthView.this._cal.add(5, -1);
                    l = JXMonthView.this._cal.getTimeInMillis();
                    bl = false;
                    break;
                }
                case 7: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._endSelectedDate);
                    JXMonthView.this._cal.add(5, 1);
                    l2 = JXMonthView.this._cal.getTimeInMillis();
                    break;
                }
                case 8: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._startSelectedDate);
                    JXMonthView.this._cal.add(5, -7);
                    l = JXMonthView.this._cal.getTimeInMillis();
                    bl = false;
                    break;
                }
                case 9: {
                    JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._endSelectedDate);
                    JXMonthView.this._cal.add(5, 7);
                    l2 = JXMonthView.this._cal.getTimeInMillis();
                }
            }
            if (l != JXMonthView.this._startSelectedDate || l2 != JXMonthView.this._endSelectedDate) {
                JXMonthView.this.setSelectedDateSpan(new DateSpan(l, l2));
                JXMonthView.this.ensureDateVisible(bl ? l2 : l);
            }
            JXMonthView.this._cal.setTimeInMillis(JXMonthView.this._firstDisplayedDate);
        }
    }
}

