/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.jdesktop.swingx.autocomplete.AbstractComponentAdaptor;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.Document;
import org.jdesktop.swingx.autocomplete.ListAdaptor;

public class Configurator {
    static Object errorFeedbackAction = new TextAction("provide-error-feedback"){

        public void actionPerformed(ActionEvent actionEvent) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getTextComponent(actionEvent));
        }
    };

    public static void enableAutoCompletion(JList jList, JTextComponent jTextComponent) {
        ListAdaptor listAdaptor = new ListAdaptor(jList, jTextComponent);
        Document document = new Document(listAdaptor, true);
        Configurator.configureTextComponent(jTextComponent, document, listAdaptor);
    }

    public static void enableAutoCompletion(final JComboBox jComboBox) {
        boolean bl = !jComboBox.isEditable();
        jComboBox.setEditable(true);
        JTextComponent jTextComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        final ComboBoxAdaptor comboBoxAdaptor = new ComboBoxAdaptor(jComboBox);
        final Document document = new Document(comboBoxAdaptor, bl);
        Configurator.configureTextComponent(jTextComponent, document, comboBoxAdaptor);
        final KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                block4: {
                    block6: {
                        block5: {
                            if (keyEvent.isActionKey()) {
                                return;
                            }
                            if (!jComboBox.isDisplayable() || jComboBox.isPopupVisible()) break block4;
                            int n = keyEvent.getKeyCode();
                            if (n == 16) break block5;
                            if (n == 17) break block5;
                            if (n != 18) break block6;
                        }
                        return;
                    }
                    jComboBox.setPopupVisible(true);
                }
            }
        };
        jTextComponent.addKeyListener(keyAdapter);
        jComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ComboBoxEditor comboBoxEditor;
                if (propertyChangeEvent.getPropertyName().equals("editor") && (comboBoxEditor = jComboBox.getEditor()) != null && comboBoxEditor.getEditorComponent() != null) {
                    Configurator.configureTextComponent((JTextComponent)comboBoxEditor.getEditorComponent(), document, comboBoxAdaptor);
                    comboBoxEditor.getEditorComponent().addKeyListener(keyAdapter);
                }
            }
        });
    }

    public static void configureTextComponent(JTextComponent jTextComponent, Document document, final AbstractComponentAdaptor abstractComponentAdaptor) {
        jTextComponent.setDocument(document);
        jTextComponent.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                abstractComponentAdaptor.markEntireText();
            }
        });
        InputMap inputMap = jTextComponent.getInputMap();
        if (document.isStrictMatching()) {
            inputMap.put(KeyStroke.getKeyStroke(8, 0), "selection-backward");
            inputMap.put(KeyStroke.getKeyStroke(127, 0), errorFeedbackAction);
            inputMap.put(KeyStroke.getKeyStroke(88, 128), errorFeedbackAction);
        } else {
            ActionMap actionMap = jTextComponent.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(8, 0), "nonstrict-backspace");
            actionMap.put("nonstrict-backspace", new NonStrictBackspaceAction(actionMap.get("delete-previous"), actionMap.get("selection-backward"), abstractComponentAdaptor));
        }
    }

    static class NonStrictBackspaceAction
    extends TextAction {
        Action backspace;
        Action selectionBackward;
        AbstractComponentAdaptor adaptor;

        public NonStrictBackspaceAction(Action action, Action action2, AbstractComponentAdaptor abstractComponentAdaptor) {
            super("nonstrict-backspace");
            this.backspace = action;
            this.selectionBackward = action2;
            this.adaptor = abstractComponentAdaptor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.adaptor.listContainsSelectedItem()) {
                this.selectionBackward.actionPerformed(actionEvent);
            } else {
                this.backspace.actionPerformed(actionEvent);
            }
        }
    }
}

