/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ComboBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor,
Serializable {
    private JComboBox comboBox;
    private Handler handler;

    public ComboBoxCellEditor(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.handler = new Handler();
        JComponent jComponent = (JComponent)jComboBox.getEditor().getEditorComponent();
        jComponent.addKeyListener(this.handler);
        jComponent.setBorder(null);
        jComboBox.addPropertyChangeListener(this.handler);
    }

    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    public boolean stopCellEditing() {
        if (this.comboBox.isEditable()) {
            this.comboBox.actionPerformed(new ActionEvent(this, 0, ""));
        }
        this.fireEditingStopped();
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.comboBox.setSelectedItem(object);
        return this.comboBox;
    }

    class Handler
    extends KeyAdapter
    implements PropertyChangeListener {
        Handler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                ComboBoxCellEditor.this.stopCellEditing();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComboBoxEditor comboBoxEditor;
            if (propertyChangeEvent.getPropertyName().equals("editor") && (comboBoxEditor = ComboBoxCellEditor.this.comboBox.getEditor()) != null && comboBoxEditor.getEditorComponent() != null) {
                JComponent jComponent = (JComponent)ComboBoxCellEditor.this.comboBox.getEditor().getEditorComponent();
                jComponent.addKeyListener(this);
                jComponent.setBorder(null);
            }
        }
    }
}

