/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.text;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public interface SubstanceTextPainter {
    public void init(JComponent var1, Rectangle var2, boolean var3);

    public boolean needsBackgroundImage();

    public void setBackgroundFill(JComponent var1, Color var2, boolean var3, int var4, int var5);

    public void attachCallback(BackgroundPaintingCallback var1);

    public void attachText(JComponent var1, Rectangle var2, String var3, int var4, Font var5, Color var6, Rectangle var7);

    public void attachVerticalText(JComponent var1, Rectangle var2, String var3, int var4, Font var5, Color var6, Rectangle var7, boolean var8);

    public void renderSurface(Graphics var1);

    public boolean isNative();

    public void dispose();

    public Dimension getTextBounds(Component var1, Font var2, String var3);

    public static class ImageBackgroundPaintingCallback
    implements BackgroundPaintingCallback {
        private BufferedImage backgroundImage;
        private Point backgroundImageAnchor;
        private float alpha;

        public ImageBackgroundPaintingCallback(BufferedImage backgroundImage, Point backgroundImageAnchor, float alpha) {
            this.backgroundImage = backgroundImage;
            this.backgroundImageAnchor = backgroundImageAnchor;
            this.alpha = alpha;
        }

        public void paintBackground(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            if (this.backgroundImageAnchor == null) {
                g2d.drawImage((Image)this.backgroundImage, 0, 0, null);
            } else {
                g2d.drawImage((Image)this.backgroundImage, this.backgroundImageAnchor.x, this.backgroundImageAnchor.y, null);
            }
            g2d.dispose();
        }
    }

    public static interface BackgroundPaintingCallback {
        public void paintBackground(Graphics var1);
    }
}

