/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceDecorationUtilities {
    private static final String DECORATION_AREA_TYPE = "substancelaf.internal.painter.decorationAreaType";

    public static void setDecorationType(JComponent comp, DecorationAreaType type) {
        comp.putClientProperty(DECORATION_AREA_TYPE, (Object)type);
    }

    public static void clearDecorationType(JComponent comp) {
        comp.putClientProperty(DECORATION_AREA_TYPE, null);
    }

    public static DecorationAreaType getDecorationType(Component comp) {
        for (Component c = comp; c != null; c = c.getParent()) {
            JComponent jc;
            Object prop;
            if (!(c instanceof JComponent) || !((prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType)) continue;
            return (DecorationAreaType)((Object)prop);
        }
        return null;
    }

    public static DecorationAreaType getImmediateDecorationType(Component comp) {
        JComponent jc;
        Object prop;
        Component c = comp;
        if (c instanceof JComponent && (prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType) {
            return (DecorationAreaType)((Object)prop);
        }
        return null;
    }

    public static void paintDecorationBackground(Graphics g, Component c, boolean force) {
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        DecorationAreaType decorationType = SubstanceDecorationUtilities.getDecorationType(c);
        SubstanceTheme decorationTheme = SubstanceThemeUtilities.getDecorationTheme(c);
        SubstanceDecorationPainter painter = SubstanceLookAndFeel.getCurrentDecorationPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), decorationTheme);
        if (!isPreviewMode && !isInCellRenderer && c.isShowing() && (SubstanceCoreUtilities.toDrawWatermark(c) || SubstanceCoreUtilities.toBleedWatermark(c))) {
            SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(g2d, c, 0, 0, c.getWidth(), c.getHeight());
            g2d.setComposite(TransitionLayout.getAlphaComposite(c, 0.5f, g));
            painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), decorationTheme);
        }
        g2d.dispose();
    }
}

