/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.LookUtils;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceDefaultTreeCellRenderer;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.highlight.SubstanceHighlightUtils;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;

public class SubstanceTreeUI
extends BasicTreeUI {
    protected Set lafWidgets;
    protected Map<TreePathId, Object> selectedPaths = new HashMap<TreePathId, Object>();
    protected TreePathId currRolloverPathId;
    private static SubstanceFillBackgroundDelegate backgroundDelegate = new SubstanceFillBackgroundDelegate();
    protected PropertyChangeListener substancePropertyChangeListener;
    protected TreeSelectionListener substanceSelectionFadeListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    protected MouseListener substanceRowSelectionListener;
    private boolean isInside = false;
    private Map<TreePathId, ComponentState> prevStateMap = new HashMap<TreePathId, ComponentState>();
    private Map<TreePathId, ComponentState> nextStateMap = new HashMap<TreePathId, ComponentState>();

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceTreeUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceTreeUI__installComponents() {
        super.installComponents();
    }

    public void installComponents() {
        this.__org__jvnet__substance__SubstanceTreeUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceTreeUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceTreeUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceTreeUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceTreeUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceTreeUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceTreeUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceTreeUI__uninstallComponents() {
        super.uninstallComponents();
    }

    public void uninstallComponents() {
        this.__org__jvnet__substance__SubstanceTreeUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceTreeUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceTreeUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent tree) {
        return new SubstanceTreeUI();
    }

    protected void __org__jvnet__substance__SubstanceTreeUI__installDefaults() {
        super.installDefaults();
        if (SubstanceCoreUtilities.toBleedWatermark(this.tree)) {
            this.tree.setOpaque(false);
        }
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath selectionPath : this.tree.getSelectionPaths()) {
                TreePathId pathId = new TreePathId(selectionPath);
                this.selectedPaths.put(pathId, selectionPath.getLastPathComponent());
                this.prevStateMap.put(pathId, ComponentState.SELECTED);
            }
        }
        this.setExpandedIcon(new IconUIResource(SubstanceIconFactory.getTreeIcon(this.tree, false)));
        this.setCollapsedIcon(new IconUIResource(SubstanceIconFactory.getTreeIcon(this.tree, true)));
    }

    protected void __org__jvnet__substance__SubstanceTreeUI__uninstallDefaults() {
        this.selectedPaths.clear();
        super.uninstallDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        AlphaComposite ac;
        int leadIndex;
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        if (this.tree.hasFocus()) {
            TreePath leadPath = this.tree.getLeadSelectionPath();
            leadIndex = this.getRowForPath(this.tree, leadPath);
        } else {
            leadIndex = -1;
        }
        final Component renderer = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
        TreePathId pathId = new TreePathId(path);
        float currFactor = 1.0f;
        Composite currComposite = ((Graphics2D)g).getComposite();
        if (currComposite instanceof AlphaComposite && (ac = (AlphaComposite)currComposite).getRule() == 3) {
            currFactor = ac.getAlpha();
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.tree, currFactor));
        Color background = renderer.getBackground();
        if (background == null) {
            background = this.tree.getBackground();
        }
        ComponentState prevState = this.getPrevPathState(pathId);
        ComponentState currState = this.getPathState(pathId);
        final SubstanceTheme prevTheme = SubstanceThemeUtilities.getHighlightTheme(this.tree, prevState);
        final SubstanceTheme currTheme = SubstanceThemeUtilities.getHighlightTheme(this.tree, currState);
        float startAlpha = SubstanceThemeUtilities.getHighlightAlpha(this.tree, prevState);
        float endAlpha = SubstanceThemeUtilities.getHighlightAlpha(this.tree, currState);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)this.tree, pathId, FadeKind.SELECTION, FadeKind.ROLLOVER);
        float totalAlpha = endAlpha;
        float fadeCoef = 0.0f;
        if (state != null) {
            fadeCoef = state.getFadePosition();
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
            if (state.isFadingIn()) {
                fadeCoef = 10.0f - fadeCoef;
            }
        }
        final boolean canHaveSubstanceEffects = !(renderer instanceof DefaultTreeCellRenderer);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        if (canHaveSubstanceEffects && totalAlpha > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.tree, currFactor * totalAlpha, g));
            SubstanceHighlightUtils.paintHighlight(g2d, renderer, new Rectangle(this.tree.getInsets().left, bounds.y, this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left, bounds.height), 0.8f, null, currTheme.getColorScheme(), prevTheme.getColorScheme(), fadeCoef);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.tree, currFactor));
        }
        final boolean isWatermarkBleed = SubstanceCoreUtilities.toBleedWatermark(this.tree);
        if (textPainter.needsBackgroundImage()) {
            final float finalTotalAlpha = totalAlpha;
            final float finalCurrFactor = currFactor;
            final float finalFadeCoef = fadeCoef;
            final Rectangle cellRect = new Rectangle(this.tree.getInsets().left - bounds.x, 0, this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left, bounds.height);
            textPainter.init(this.tree, cellRect, true);
            textPainter.setBackgroundFill(this.tree, background, true, bounds.x, bounds.y);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    if (!isWatermarkBleed) {
                        g2d.setColor(renderer.getBackground());
                        g2d.fillRect(0, 0, cellRect.width, cellRect.height);
                    } else {
                        backgroundDelegate.fillAndWatermark(g2d, SubstanceTreeUI.this.tree, renderer.getBackground(), cellRect);
                    }
                    g2d.dispose();
                }
            });
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    if (canHaveSubstanceEffects && finalTotalAlpha > 0.0f) {
                        g2d.setComposite(TransitionLayout.getAlphaComposite(SubstanceTreeUI.this.tree, finalCurrFactor * finalTotalAlpha, g));
                        SubstanceHighlightUtils.paintHighlight(g2d, renderer, cellRect, 0.8f, null, currTheme.getColorScheme(), prevTheme.getColorScheme(), finalFadeCoef);
                        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)SubstanceTreeUI.this.tree, finalCurrFactor));
                    }
                }
            });
        }
        this.tree.putClientProperty("substancelaf.internal.textPainter.doNotFillBackground", Boolean.TRUE);
        if (renderer instanceof JComponent) {
            JComponent jRenderer;
            JComponent jComponent = jRenderer = (JComponent)renderer;
            synchronized (jComponent) {
                boolean newOpaque;
                boolean bl = newOpaque = !this.tree.isRowSelected(row);
                if (SubstanceCoreUtilities.toBleedWatermark(this.tree)) {
                    newOpaque = false;
                }
                newOpaque = newOpaque && canHaveSubstanceEffects;
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g2d, renderer, this.tree, bounds.x, bounds.y, Math.max(this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left - bounds.x, bounds.width), bounds.height, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            }
        } else {
            this.rendererPane.paintComponent(g2d, renderer, this.tree, bounds.x, bounds.y, Math.max(clipBounds.width, bounds.width), bounds.height, true);
        }
        this.tree.putClientProperty("substancelaf.internal.textPainter.doNotFillBackground", null);
        if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
            if (!this.tree.getComponentOrientation().isLeftToRight() && LookUtils.IS_JAVA_5) {
                bounds.x -= 4;
            }
            this.paintExpandControlEnforce(g2d, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
        g2d.dispose();
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    protected void paintExpandControlEnforce(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean toPaint = !this.tree.isEnabled() || this.isInside || !FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, this.tree);
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.tree);
        float alpha = theme.getThemeAlpha(this.tree, this.tree.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        Graphics2D graphics = (Graphics2D)g.create();
        if (FadeTracker.getInstance().isTracked(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND)) {
            toPaint = true;
            alpha *= FadeTracker.getInstance().getFade10(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND) / 10.0f;
        }
        if (toPaint) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.tree, alpha, g));
            super.paintExpandControl(graphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
        graphics.dispose();
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Graphics2D graphics = (Graphics2D)g.create();
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tree));
        graphics.setStroke(new BasicStroke(strokeWidth, 1, 2));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean toPaint = !this.tree.isEnabled() || this.isInside || !FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, this.tree);
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.tree);
        float alpha = theme.getThemeAlpha(this.tree, this.tree.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        if (FadeTracker.getInstance().isTracked(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND)) {
            toPaint = true;
            alpha *= FadeTracker.getInstance().getFade10(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND) / 10.0f;
        }
        if (toPaint) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.tree, alpha, g));
            super.paintHorizontalPartOfLeg(graphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
        graphics.dispose();
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        Graphics2D graphics = (Graphics2D)g.create();
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tree));
        graphics.setStroke(new BasicStroke(strokeWidth, 0, 2));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean toPaint = !this.tree.isEnabled() || this.isInside || !FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, this.tree);
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.tree);
        float alpha = theme.getThemeAlpha(this.tree, this.tree.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        if (FadeTracker.getInstance().isTracked(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND)) {
            toPaint = true;
            alpha *= FadeTracker.getInstance().getFade10(this.tree, SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND) / 10.0f;
        }
        if (toPaint) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.tree, alpha, g));
            super.paintVerticalPartOfLeg(graphics, clipBounds, insets, path);
        }
        graphics.dispose();
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new SubstanceDefaultTreeCellRenderer();
    }

    protected void __org__jvnet__substance__SubstanceTreeUI__installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    SubstanceTreeUI.this.tree.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(SubstanceTreeUI.this.tree));
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceTreeUI.this.tree.updateUI();
                        }
                    });
                }
            }
        };
        this.tree.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceSelectionFadeListener = new MyTreeSelectionListener();
        this.tree.getSelectionModel().addTreeSelectionListener(this.substanceSelectionFadeListener);
        this.substanceRowSelectionListener = new RowSelectionListener();
        this.tree.addMouseListener(this.substanceRowSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.tree.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.tree.addMouseListener(this.substanceFadeRolloverListener);
    }

    protected void __org__jvnet__substance__SubstanceTreeUI__uninstallListeners() {
        this.tree.removeMouseListener(this.substanceRowSelectionListener);
        this.substanceRowSelectionListener = null;
        this.tree.getSelectionModel().removeTreeSelectionListener(this.substanceSelectionFadeListener);
        this.substanceSelectionFadeListener = null;
        this.tree.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.tree.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.tree.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    public int getPivotRendererX(Rectangle paintBounds) {
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        int totalY = 0;
        int count = 0;
        if (initialPath != null && paintingEnumerator != null) {
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            Insets insets = this.tree.getInsets();
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    Rectangle bounds = this.treeState.getBounds(path, boundsBuffer);
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    int currMedianX = bounds.x;
                    totalY += currMedianX;
                    ++count;
                    if (bounds.y + bounds.height < endY) continue;
                    done = true;
                    continue;
                }
                done = true;
            }
        }
        if (count == 0) {
            return -1;
        }
        return totalY / count - 2 * SubstanceSizeUtils.getTreeIconSize(SubstanceSizeUtils.getComponentFontSize(this.tree));
    }

    public ComponentState getPrevPathState(TreePathId pathId) {
        if (this.prevStateMap.containsKey(pathId)) {
            return this.prevStateMap.get(pathId);
        }
        return ComponentState.DEFAULT;
    }

    public ComponentState getPathState(TreePathId pathId) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.tree.isEnabled());
        synthModel.setRollover(this.currRolloverPathId != null && pathId.equals(this.currRolloverPathId));
        int rowIndex = this.tree.getRowForPath(pathId.path);
        synthModel.setSelected(this.tree.isRowSelected(rowIndex));
        return ComponentState.getState(synthModel, null);
    }

    public void __org__jvnet__substance__SubstanceTreeUI__update(Graphics g, JComponent c) {
        SubstanceFillBackgroundDelegate.GLOBAL_INSTANCE.updateIfOpaque(g, c);
        if (this.treeState == null) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        boolean isWatermarkBleed = SubstanceCoreUtilities.toBleedWatermark(this.tree) || !this.tree.isOpaque();
        Graphics2D g2d = (Graphics2D)g.create();
        if (initialPath != null && paintingEnumerator != null) {
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    boolean isExpanded = isLeaf ? false : this.treeState.getExpandedState(path);
                    Component renderer = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, this.tree.hasFocus() ? this.tree.getLeadSelectionRow() == row : false);
                    Color background = renderer.getBackground();
                    if (background == null) {
                        background = this.tree.getBackground();
                    }
                    Rectangle bounds = this.treeState.getBounds(path, boundsBuffer);
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    if (!isWatermarkBleed) {
                        g2d.setColor(background);
                        g2d.fillRect(paintBounds.x, bounds.y, paintBounds.width, bounds.height);
                    } else if (this.tree.getComponentOrientation().isLeftToRight()) {
                        backgroundDelegate.fillAndWatermark(g2d, this.tree, background, new Rectangle(paintBounds.x, bounds.y, paintBounds.width, bounds.height));
                    } else {
                        backgroundDelegate.fillAndWatermark(g2d, this.tree, background, new Rectangle(paintBounds.x, bounds.y, paintBounds.width, bounds.height));
                    }
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.paint(g2d, c);
        g2d.dispose();
    }

    protected Color getHashColor() {
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.tree, this.tree.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        Color curr = theme.getLineColor();
        return curr;
    }

    private class RowSelectionListener
    extends MouseAdapter {
        private RowSelectionListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            TreePath closestPath = SubstanceTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (closestPath == null) {
                return;
            }
            Rectangle bounds = SubstanceTreeUI.this.tree.getPathBounds(closestPath);
            if (e.getY() >= bounds.y && e.getY() < bounds.y + bounds.height && (e.getX() < bounds.x || e.getX() > bounds.x + bounds.width)) {
                if (SubstanceTreeUI.this.isLocationInExpandControl(closestPath, e.getX(), e.getY())) {
                    return;
                }
                SubstanceTreeUI.this.selectPathForEvent(closestPath, e);
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            SubstanceTreeUI.this.isInside = true;
            if (FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree)) {
                FadeTracker.getInstance().trackFadeIn(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree, false, null);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            SubstanceTreeUI.this.isInside = false;
            if (FadeConfigurationManager.getInstance().fadeAllowed(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree)) {
                FadeTracker.getInstance().trackFadeOut(SubstanceLookAndFeel.TREE_DECORATIONS_ANIMATION_KIND, SubstanceTreeUI.this.tree, false, null);
            }
            this.fadeOut();
            SubstanceTreeUI.this.currRolloverPathId = null;
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            SubstanceTreeUI.this.isInside = true;
            this.handleMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            TreePath closestPath = SubstanceTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            Rectangle bounds = SubstanceTreeUI.this.tree.getPathBounds(closestPath);
            if (bounds == null) {
                this.fadeOut();
                SubstanceTreeUI.this.currRolloverPathId = null;
                return;
            }
            if (e.getY() < bounds.y || e.getY() > bounds.y + bounds.height) {
                this.fadeOut();
                SubstanceTreeUI.this.currRolloverPathId = null;
                return;
            }
            TreePathId newPathId = new TreePathId(closestPath);
            if (SubstanceTreeUI.this.currRolloverPathId != null && newPathId.equals(SubstanceTreeUI.this.currRolloverPathId)) {
                return;
            }
            this.fadeOut();
            FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceTreeUI.this.tree, newPathId, false, (FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, closestPath));
            SubstanceTreeUI.this.currRolloverPathId = newPathId;
        }

        private void fadeOut() {
            if (SubstanceTreeUI.this.currRolloverPathId == null) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceTreeUI.this.tree, SubstanceTreeUI.this.currRolloverPathId, false, (FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, SubstanceTreeUI.this.currRolloverPathId.path));
        }
    }

    protected class PathRepaintCallback
    extends FadeTrackerAdapter {
        protected JTree tree;
        protected TreePath treePath;

        public PathRepaintCallback(JTree tree, TreePath treePath) {
            this.tree = tree;
            this.treePath = treePath;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTreeUI.this.tree == this.tree) {
                TreePathId pathId = new TreePathId(this.treePath);
                ComponentState currState = SubstanceTreeUI.this.getPathState(pathId);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceTreeUI.this.prevStateMap.remove(pathId);
                    SubstanceTreeUI.this.nextStateMap.remove(pathId);
                } else {
                    SubstanceTreeUI.this.prevStateMap.put(pathId, currState);
                    SubstanceTreeUI.this.nextStateMap.put(pathId, currState);
                }
            }
            this.repaintPath();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceTreeUI.this.tree == this.tree) {
                TreePathId pathId = new TreePathId(this.treePath);
                SubstanceTreeUI.this.nextStateMap.put(pathId, SubstanceTreeUI.this.getPathState(pathId));
            }
            this.repaintPath();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTreeUI.this.tree == this.tree) {
                TreePathId pathId = new TreePathId(this.treePath);
                ComponentState nextState = (ComponentState)((Object)SubstanceTreeUI.this.nextStateMap.get(pathId));
                if (nextState == null) {
                    SubstanceTreeUI.this.prevStateMap.remove(pathId);
                } else {
                    SubstanceTreeUI.this.prevStateMap.put(pathId, nextState);
                }
            }
            this.repaintPath();
        }

        private void repaintPath() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTreeUI.this.tree == null) {
                        return;
                    }
                    Rectangle boundsBuffer = new Rectangle();
                    Rectangle bounds = SubstanceTreeUI.this.treeState.getBounds(PathRepaintCallback.this.treePath, boundsBuffer);
                    if (bounds != null) {
                        bounds.x = 0;
                        bounds.width = PathRepaintCallback.this.tree.getWidth();
                        Insets insets = PathRepaintCallback.this.tree.getInsets();
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        PathRepaintCallback.this.tree.repaint(bounds);
                    }
                }
            });
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (SubstanceTreeUI.this.tree.getSelectionPaths() != null) {
                for (TreePath selectionPath : SubstanceTreeUI.this.tree.getSelectionPaths()) {
                    TreePathId pathId = new TreePathId(selectionPath);
                    if (SubstanceTreeUI.this.selectedPaths.containsKey(pathId)) continue;
                    FadeTracker.getInstance().trackFadeIn(FadeKind.SELECTION, (Component)SubstanceTreeUI.this.tree, pathId, false, (FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, selectionPath));
                    SubstanceTreeUI.this.selectedPaths.put(pathId, selectionPath.getLastPathComponent());
                }
            }
            Iterator<Map.Entry<TreePathId, Object>> it = SubstanceTreeUI.this.selectedPaths.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TreePathId, Object> entry = it.next();
                if (SubstanceTreeUI.this.tree.getSelectionModel().isPathSelected(entry.getKey().path)) continue;
                FadeTracker.getInstance().trackFadeOut(FadeKind.SELECTION, (Component)SubstanceTreeUI.this.tree, entry.getKey(), false, (FadeTrackerCallback)new PathRepaintCallback(SubstanceTreeUI.this.tree, entry.getKey().path));
                it.remove();
            }
        }
    }

    protected static class TreePathId
    implements Comparable {
        protected TreePath path;

        public TreePathId(TreePath path) {
            this.path = path;
        }

        public int compareTo(Object o) {
            if (o instanceof TreePathId) {
                Object[] path2Objs;
                TreePathId otherId = (TreePathId)o;
                if (this.path == null && otherId.path != null) {
                    return 1;
                }
                if (otherId.path == null && this.path != null) {
                    return -1;
                }
                Object[] path1Objs = this.path.getPath();
                if (path1Objs.length != (path2Objs = otherId.path.getPath()).length) {
                    return 1;
                }
                for (int i = 0; i < path1Objs.length; ++i) {
                    if (path1Objs[i].equals(path2Objs[i])) continue;
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            if (this.path == null) {
                return 0;
            }
            Object[] pathObjs = this.path.getPath();
            int result = pathObjs[0].hashCode();
            for (int i = 1; i < pathObjs.length; ++i) {
                result ^= pathObjs[i].hashCode();
            }
            return result;
        }
    }
}

