/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceFillBackgroundDelegate {
    private float watermarkAlpha;
    public static final SubstanceFillBackgroundDelegate GLOBAL_INSTANCE = new SubstanceFillBackgroundDelegate();

    public SubstanceFillBackgroundDelegate() {
        this(1.0f);
    }

    public SubstanceFillBackgroundDelegate(float watermarkAlpha) {
        this.watermarkAlpha = watermarkAlpha;
    }

    public void updateIfOpaque(Graphics g, Component c) {
        if (TransitionLayout.isOpaque(c)) {
            this.update(g, c, false);
        }
    }

    public void update(Graphics g, Component c, boolean force) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, g));
        DecorationAreaType decorationType = SubstanceDecorationUtilities.getDecorationType(c);
        SubstanceTheme componentTheme = SubstanceThemeUtilities.getNonColorizedTheme(c, true);
        if (decorationType != null && componentTheme.toUseDecorationPainter(decorationType)) {
            SubstanceDecorationUtilities.paintDecorationBackground(graphics, c, force);
        } else {
            Color backgr = SubstanceCoreUtilities.getBackgroundFillColor(c);
            graphics.setColor(backgr);
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            if ((c instanceof JToolBar || SwingUtilities.getAncestorOfClass(JToolBar.class, c) != null) && componentTheme.isPaintingToolbarDropShadows()) {
                Color headerColor = SubstanceColorUtilities.getBackgroundColor(SubstanceLookAndFeel.getTheme()).darker();
                int dy = 0;
                int totalOffsetY = 0;
                Component comp = c;
                while (comp.getParent() != null) {
                    Container parent = comp.getParent();
                    dy += comp.getY();
                    if (parent instanceof JToolBar) {
                        totalOffsetY += dy;
                        dy = 0;
                    }
                    comp = parent;
                }
                graphics.translate(0, -totalOffsetY);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(headerColor, 160), 0.0f, 4.0f, SubstanceColorUtilities.getAlphaColor(headerColor, 16)));
                graphics.fillRect(0, 0, c.getWidth(), 4);
                graphics.translate(0, totalOffsetY);
            }
            if (!isPreviewMode && !isInCellRenderer && c.isShowing() && (SubstanceCoreUtilities.toDrawWatermark(c) || SubstanceCoreUtilities.toBleedWatermark(c))) {
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, c, 0, 0, c.getWidth(), c.getHeight());
            }
        }
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillAndWatermark(Graphics g, JComponent c, Color fillColor, Rectangle rect) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        JComponent jComponent = c;
        synchronized (jComponent) {
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, g));
            graphics.setColor(fillColor);
            graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
            graphics.setComposite(TransitionLayout.getAlphaComposite(c, this.watermarkAlpha, g));
            if (!isInCellRenderer && c.isShowing() && (SubstanceCoreUtilities.toDrawWatermark(c) || SubstanceCoreUtilities.toBleedWatermark(c))) {
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, c, rect.x, rect.y, rect.width, rect.height);
            }
        }
        graphics.dispose();
    }

    public void setWatermarkAlpha(float watermarkAlpha) {
        this.watermarkAlpha = watermarkAlpha;
    }
}

