/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceDefaultComboBoxRenderer;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceListUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.combo.SubstanceComboBoxEditor;
import org.jvnet.substance.combo.SubstanceComboPopup;
import org.jvnet.substance.painter.highlight.SubstanceHighlightUtils;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    protected Set lafWidgets;
    protected ComboBoxPropertyChangeHandler substanceChangeHandler;
    protected FadeStateListener substanceFadeStateListener;
    protected FocusListener substanceFocusListener;
    private static SubstanceFillBackgroundDelegate backgroundDelegate = new SubstanceFillBackgroundDelegate();

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceComboBoxUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__installComponents() {
        super.installComponents();
    }

    public void installComponents() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceComboBoxUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallComponents() {
        super.uninstallComponents();
    }

    public void uninstallComponents() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent b) {
        SubstanceComboBoxUI ui = new SubstanceComboBoxUI();
        ui.comboBox = (JComboBox)b;
        ui.comboBox.setOpaque(false);
        return ui;
    }

    protected JButton createArrowButton() {
        SubstanceComboBoxButton result = new SubstanceComboBoxButton(this.comboBox);
        result.setIcon(this.comboBox, this.getCurrentIcon(result));
        result.setFont(this.comboBox.getFont());
        return result;
    }

    private Icon getCurrentIcon(JButton button) {
        Icon icon = SubstanceCoreUtilities.getArrowIcon(this.comboBox, button, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        return icon;
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceDefaultComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    protected void __org__jvnet__substance__SubstanceComboBoxUI__installListeners() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
        this.substanceFadeStateListener = new FadeStateListener(this.comboBox, null, null);
        this.substanceFadeStateListener.registerListeners();
    }

    protected void __org__jvnet__substance__SubstanceComboBoxUI__uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__SubstanceComboBoxUI__installDefaults() {
        super.installDefaults();
        Border b = this.comboBox.getBorder();
        if (b == null || b instanceof UIResource) {
            SubstanceBorder newB = new SubstanceBorder(SubstanceSizeUtils.getComboBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.comboBox)));
            this.comboBox.setBorder(newB);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    protected Dimension getDefaultSize() {
        Component rend = new SubstanceDefaultComboBoxRenderer(this.comboBox).getListCellRendererComponent(this.listBox, (Object)" ", -1, false, false);
        rend.setFont(this.comboBox.getFont());
        return rend.getPreferredSize();
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        SubstanceComboBoxButton button = (SubstanceComboBoxButton)this.arrowButton;
        Insets buttonInsets = button.getInsets();
        Insets insets = this.comboBox.getInsets();
        Dimension size = this.getDisplaySize();
        size.width += insets.left + insets.right;
        size.width += buttonInsets.left + buttonInsets.right;
        size.width = (int)((double)size.width + button.getMinimumSize().getWidth());
        size.height += insets.top + insets.bottom;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected ComboPopup createPopup() {
        final SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        final ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComboBoxEditor editor;
                ListCellRenderer cellRenderer;
                if (SubstanceComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (sPopup instanceof Component) {
                    Component cPopup = (Component)((Object)sPopup);
                    cPopup.applyComponentOrientation(currOrientation);
                    cPopup.doLayout();
                }
                if ((cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
                }
                if ((editor = SubstanceComboBoxUI.this.comboBox.getEditor()) != null && editor.getEditorComponent() instanceof Component) {
                    editor.getEditorComponent().applyComponentOrientation(currOrientation);
                }
                SubstanceComboBoxUI.this.comboBox.repaint();
            }
        });
        return sPopup;
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean isSelected;
        ListUI listUI = this.popup.getList().getUI();
        SubstanceListUI ui = (SubstanceListUI)listUI;
        ComponentState state = ui.getCellState(-1);
        boolean isEnabled = this.comboBox.isEnabled();
        boolean bl = isSelected = hasFocus || SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox);
        if (isSelected && isEnabled) {
            state = ComponentState.SELECTED;
        }
        if (!isEnabled) {
            state = ComponentState.DISABLED_UNSELECTED;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.comboBox, state);
        final ColorScheme colorScheme = theme.getColorScheme();
        float alpha = theme.getThemeAlpha(this.comboBox, state);
        if (!SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox)) {
            alpha = 0.8f * alpha;
        }
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        boolean toRegardAsFocused = hasFocus || SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox);
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, toRegardAsFocused, hasFocus);
        Color background = c.getBackground();
        if (!(background instanceof UIResource)) {
            double colorization = SubstanceCoreUtilities.getColorizationFactor(this.comboBox);
            if (!this.comboBox.isEnabled()) {
                colorization /= 2.0;
            }
            if (colorization > 0.0) {
                alpha = (float)((double)alpha * (1.0 - colorization));
            }
        }
        final float finalAlpha = alpha;
        Rectangle newBounds = new Rectangle(1, 1, this.comboBox.getWidth() - 2, this.comboBox.getHeight() - 2);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init(this.comboBox, null, true);
        if (textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundFill(this.comboBox, this.comboBox.getBackground(), false, 0, 0);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setComposite(TransitionLayout.getAlphaComposite(SubstanceComboBoxUI.this.comboBox, finalAlpha, g));
                    SubstanceHighlightUtils.paintHighlight(g2d, SubstanceComboBoxUI.this.comboBox, new Rectangle(0, 0, SubstanceComboBoxUI.this.comboBox.getWidth(), SubstanceComboBoxUI.this.comboBox.getHeight()), 0.0f, null, colorScheme, colorScheme, 0.0f);
                    g2d.dispose();
                }
            });
            textPainter.attachText(this.comboBox, newBounds, " ", -1, graphics.getFont(), graphics.getColor(), graphics.getClipBounds());
            textPainter.renderSurface(graphics);
        } else {
            backgroundDelegate.fillAndWatermark(graphics, this.comboBox, background, newBounds);
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.comboBox, finalAlpha, g));
            SubstanceHighlightUtils.paintHighlight(graphics, this.comboBox, newBounds, 0.0f, null, colorScheme, colorScheme, 0.0f);
        }
        graphics.dispose();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState state = this.comboBox.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        float alpha = SubstanceThemeUtilities.getTheme(this.comboBox).getThemeAlpha(this.comboBox, state);
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.comboBox, alpha, g));
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = hasFocus || SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, hasFocus) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, hasFocus);
        c.setFont(this.comboBox.getFont());
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        if (c instanceof JComponent) {
            this.comboBox.putClientProperty("substancelaf.internal.textPainter.doNotFillBackground", Boolean.TRUE);
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            this.currentValuePane.paintComponent(graphics, c, this.comboBox, 1, 1, this.arrowButton.getX() - 1, this.comboBox.getHeight() - 2, shouldValidate);
        } else {
            int startX = this.arrowButton.getX() + this.arrowButton.getWidth();
            this.currentValuePane.paintComponent(graphics, c, this.comboBox, startX, 1, this.comboBox.getWidth() - startX - 1, this.comboBox.getHeight() - 2, shouldValidate);
        }
        if (c instanceof JComponent) {
            this.comboBox.putClientProperty("substancelaf.internal.textPainter.doNotFillBackground", null);
        }
        graphics.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable() && this.hasFocus) {
            Rectangle r = this.rectangleForCurrentValue();
            ++r.y;
            r.height -= 2;
            r.width -= this.arrowButton.getWidth() + 10;
            this.paintFocus(g, r);
        }
    }

    protected void paintFocus(Graphics g, Rectangle bounds) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        int focusRingPadding = SubstanceSizeUtils.getFocusRingPadding(fontSize);
        SubstanceCoreUtilities.paintFocus(g, this.comboBox, this.comboBox, BaseButtonShaper.getBaseOutline(this.arrowButton.getX() - 1, this.comboBox.getHeight() - 3 * focusRingPadding / 2, SubstanceSizeUtils.getClassicButtonCornerRadius(fontSize), null, 0), bounds, 0.4f, 3 * focusRingPadding / 2);
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__update(Graphics g, JComponent c) {
        if (!this.comboBox.isEditable()) {
            SubstanceCoreUtilities.paintTextCompBackground(g, c);
        } else {
            SubstanceCoreUtilities.paintTextCompBackground(g, c, this.editor.getBackground(), false);
        }
        this.paint(g, c);
    }

    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
        this.substanceFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                SubstanceComboBoxUI.this.arrowButton.setSelected(true);
            }

            public void focusLost(FocusEvent e) {
                SubstanceComboBoxUI.this.arrowButton.setSelected(false);
            }
        };
        this.arrowButton.setSelected(this.comboBox.hasFocus());
        this.comboBox.addFocusListener(this.substanceFocusListener);
        this.configureArrowButtonStraightSide();
    }

    protected void configureArrowButtonStraightSide() {
        this.arrowButton.putClientProperty("substancelaf.buttonside", (Object)(this.comboBox.getComponentOrientation().isLeftToRight() ? SubstanceConstants.Side.LEFT : SubstanceConstants.Side.RIGHT));
    }

    public void unconfigureArrowButton() {
        this.comboBox.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        super.unconfigureArrowButton();
    }

    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            Insets ins = SubstanceSizeUtils.getComboTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editor));
            ((JComponent)this.editor).setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            this.editor.setBackground(this.comboBox.getBackground());
        }
    }

    protected ComboBoxEditor createEditor() {
        return new SubstanceComboBoxEditor.UIResource();
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        public void propertyChange(final PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubstanceComboBoxUI.this.comboBox == null) {
                            return;
                        }
                        ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                        ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                        ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                        if (SubstanceComboBoxUI.this.popup instanceof Component) {
                            Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                            cPopup.applyComponentOrientation(newOrientation);
                            cPopup.doLayout();
                        }
                        if (cellRenderer instanceof Component) {
                            ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                        }
                        if (editor != null && editor.getEditorComponent() instanceof Component) {
                            editor.getEditorComponent().applyComponentOrientation(newOrientation);
                        }
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.repaint();
                        }
                        SubstanceComboBoxUI.this.configureArrowButtonStraightSide();
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(propertyName)) {
                ((SubstanceComboBoxButton)SubstanceComboBoxUI.this.arrowButton).setIcon(SubstanceComboBoxUI.this.comboBox, SubstanceCoreUtilities.getArrowIcon(SubstanceComboBoxUI.this.comboBox, SubstanceComboBoxUI.this.arrowButton, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
            if ("font".equals(propertyName)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SubstanceComboBoxUI.this.comboBox.updateUI();
                    }
                });
            }
            if ("background".equals(propertyName) && SubstanceComboBoxUI.this.comboBox.isEditable()) {
                SubstanceComboBoxUI.this.comboBox.getEditor().getEditorComponent().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
                SubstanceComboBoxUI.this.popup.getList().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(SubstanceComboBoxUI.this.comboBox));
            buttonWidth = Math.max(buttonWidth, ((SubstanceComboBoxUI)SubstanceComboBoxUI.this).arrowButton.getPreferredSize().width);
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - buttonWidth - insets.right, 0, buttonWidth + insets.right, height);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, buttonWidth + insets.left, height);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

