/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected float alpha = 1.0f;
    protected float radiusFactor = 0.5f;

    public SubstanceBorder() {
    }

    public SubstanceBorder(float radiusFactor) {
        this();
        this.radiusFactor = radiusFactor;
    }

    public SubstanceBorder(Insets insets) {
        this();
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private void paintBorder(Component c, Graphics g, int x, int y, int width, int height, boolean isEnabled, boolean hasFocus, float alpha) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, alpha, g));
        float cyclePos = 1.0f;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        boolean isFocusAnimated = fadeTracker.isTracked(c, FadeKind.FOCUS);
        boolean isBorderAnimated = fadeTracker.isTracked(c, SubstanceLookAndFeel.BORDER_ANIMATION_KIND);
        float radius = this.radiusFactor * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(c));
        if (isFocusAnimated || isBorderAnimated || c.hasFocus()) {
            cyclePos = isFocusAnimated ? fadeTracker.getFade10(c, FadeKind.FOCUS) / 10.0f : (isBorderAnimated ? fadeTracker.getFade10(c, SubstanceLookAndFeel.BORDER_ANIMATION_KIND) / 10.0f : 1.0f);
            SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, radius, SubstanceThemeUtilities.getTheme(c, ComponentState.DEFAULT));
            if (cyclePos > 0.0f) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(c, cyclePos * alpha, g));
                SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, radius, SubstanceThemeUtilities.getTheme(c, ComponentState.SELECTED));
            }
        } else if (isEnabled) {
            SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, radius, SubstanceThemeUtilities.getTheme(c, ComponentState.DEFAULT));
        } else {
            SubstanceTheme controlDisabledTheme = SubstanceThemeUtilities.getTheme(c, ComponentState.DISABLED_UNSELECTED);
            float disabledTrans = 1.0f;
            if (!(c instanceof AbstractButton)) {
                disabledTrans = SubstanceThemeUtilities.getTheme(c).getThemeAlpha(c, ComponentState.DISABLED_SELECTED);
            }
            Graphics2D tempGr = (Graphics2D)graphics.create();
            tempGr.setComposite(TransitionLayout.getAlphaComposite(c, disabledTrans, graphics));
            SubstanceImageCreator.paintBorder(c, tempGr, x, y, width, height, radius, controlDisabledTheme);
            tempGr.dispose();
        }
        if (fadeTracker.isTracked(c, FadeKind.FOCUS_LOOP_ANIMATION)) {
            float coef = 0.4f;
            if (fadeTracker.isTracked(c, FadeKind.FOCUS)) {
                coef = 0.4f * fadeTracker.getFade10(c, FadeKind.FOCUS) / 10.0f;
            }
            graphics.setComposite(TransitionLayout.getAlphaComposite(c, coef * alpha, g));
            int extraPadding = SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(c));
            SubstanceCoreUtilities.paintFocus(graphics, c, c, null, new Rectangle(1, 1, c.getWidth() - 1, c.getHeight() - 1), coef, extraPadding);
        }
        graphics.dispose();
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorder(c, g, x, y, width, height, c.isEnabled(), c.hasFocus(), this.alpha);
    }

    public Insets getBorderInsets(Component c) {
        if (this.myInsets == null) {
            return SubstanceSizeUtils.getDefaultBorderInsets(SubstanceSizeUtils.getComponentFontSize(c));
        }
        return this.myInsets;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

