/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;

public class GeoJSONReader {
    private static final Logger LOGGER = Logging.getLogger((String)GeoJSONReader.class.getName());
    private FeatureJSON reader = new FeatureJSON();
    private InputStream inputStream;
    private URL url;

    public GeoJSONReader(URL url) {
        this.url = url;
    }

    public boolean isConnected() {
        try {
            this.inputStream = this.url.openStream();
            if (this.inputStream == null) {
                this.url = new URL(this.url.toExternalForm());
                this.inputStream = this.url.openStream();
            }
        }
        catch (IOException e) {
            return false;
        }
        try {
            if (this.inputStream.available() == 0) {
                this.url = new URL(this.url.toExternalForm());
                this.inputStream = this.url.openStream();
            }
            LOGGER.finest("inputstream is " + this.inputStream);
            return this.inputStream != null && this.inputStream.available() > 0;
        }
        catch (IOException e) {
            LOGGER.throwing(this.getClass().getName(), "isConnected", e);
            return false;
        }
    }

    public FeatureCollection getFeatures() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        this.reader = new FeatureJSON();
        LOGGER.fine("reading features from " + this.url.toExternalForm() + " inputstream");
        FeatureCollection collection = this.reader.readFeatureCollection(this.inputStream);
        this.inputStream.close();
        return collection;
    }

    public FeatureIterator<SimpleFeature> getIterator() throws IOException {
        if (!this.isConnected()) {
            return new DefaultFeatureCollection(null, null).features();
        }
        return this.reader.streamFeatureCollection(this.inputStream);
    }

    public FeatureType getSchema() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        FeatureType schema = this.reader.readFeatureCollection(this.inputStream).getSchema();
        return schema;
    }
}

