/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.geojson.GeoJSONDataStore;
import org.geotools.util.KVP;

public class GeoJSONDataStoreFactory
implements DataStoreFactorySpi {
    public static final String[] EXTS = new String[]{"geojson", "json"};
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "url to a .json file", true, null, (Map)new KVP(new Object[]{"ext", "json", "ext", "geojson"}));
    Boolean isAvailable = null;

    public String getDisplayName() {
        return "GeoJSON";
    }

    public String getDescription() {
        return "GeoJSON files and URLsi containing feature collections.";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP};
    }

    public boolean canProcess(Map<String, Serializable> params) {
        try {
            URL url = (URL)URLP.lookUp(params);
            if (url != null) {
                for (String ext : EXTS) {
                    if (!FilenameUtils.getExtension((String)url.toExternalForm()).equalsIgnoreCase(ext)) continue;
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public synchronized boolean isAvailable() {
        if (this.isAvailable == null) {
            try {
                Class<?> geoJSONReaderType = Class.forName("org.geotools.geojson.feature.FeatureJSON");
                this.isAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.isAvailable = false;
            }
        }
        return this.isAvailable;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        URL url = (URL)URLP.lookUp(params);
        return new GeoJSONDataStore(url);
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        URL url = (URL)URLP.lookUp(params);
        String scheme = url.getProtocol();
        String host = url.getHost();
        if ("file".equalsIgnoreCase(scheme) && (host == null || host.isEmpty())) {
            return new GeoJSONDataStore(url);
        }
        throw new IllegalArgumentException("unable to write to remote URLs");
    }
}

