/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.Query;
import org.geotools.data.geojson.GeoJSONFeatureSource;
import org.geotools.data.geojson.GeoJSONFeatureStore;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class GeoJSONDataStore
extends ContentDataStore {
    URL url;
    SimpleFeatureType schema;
    protected Name typeName;

    public GeoJSONDataStore(URL url) throws IOException {
        this.url = url;
    }

    protected List<Name> createTypeNames() throws IOException {
        String name = FilenameUtils.getBaseName((String)this.url.toExternalForm());
        this.typeName = new NameImpl(name);
        return Collections.singletonList(this.typeName);
    }

    GeoJSONReader read() {
        GeoJSONReader reader = null;
        reader = new GeoJSONReader(this.url);
        return reader;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        String scheme = this.url.getProtocol();
        String host = this.url.getHost();
        if ("file".equalsIgnoreCase(scheme) && (host == null || host.isEmpty())) {
            GeoJSONFeatureStore geoJSONFeatureStore = new GeoJSONFeatureStore(entry, Query.ALL);
            return geoJSONFeatureStore;
        }
        GeoJSONFeatureSource geoJSONFeatureSource = new GeoJSONFeatureSource(entry, Query.ALL);
        return geoJSONFeatureSource;
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.schema = featureType;
    }
}

