/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class AquaSliderUI
extends BasicSliderUI
implements AquaUtilControlSize.Sizeable {
    private static final Dimension MAC_PREFERRED_HORIZONTAL_SIZE = new Dimension(190, 21);
    private static final Dimension MAC_PREFERRED_VERTICAL_SIZE = new Dimension(21, 190);
    protected static final AquaUtils.LazySingleton<AquaUtilControlSize.SizeDescriptor> roundThumbDescriptor = new AquaUtils.LazySingleton<AquaUtilControlSize.SizeDescriptor>(){

        @Override
        protected AquaUtilControlSize.SizeDescriptor getInstance() {
            return new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(25, 25)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant sizeVariant) {
                    return super.deriveSmall(sizeVariant.alterMinSize(-2, -2));
                }

                @Override
                public AquaUtilControlSize.SizeVariant deriveMini(AquaUtilControlSize.SizeVariant sizeVariant) {
                    return super.deriveMini(sizeVariant.alterMinSize(-2, -2));
                }
            };
        }
    };
    protected static final AquaUtils.LazySingleton<AquaUtilControlSize.SizeDescriptor> pointingThumbDescriptor = new AquaUtils.LazySingleton<AquaUtilControlSize.SizeDescriptor>(){

        @Override
        protected AquaUtilControlSize.SizeDescriptor getInstance() {
            return new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(23, 26)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant sizeVariant) {
                    return super.deriveSmall(sizeVariant.alterMinSize(-2, -2));
                }

                @Override
                public AquaUtilControlSize.SizeVariant deriveMini(AquaUtilControlSize.SizeVariant sizeVariant) {
                    return super.deriveMini(sizeVariant.alterMinSize(-2, -2));
                }
            };
        }
    };
    final AquaPainter<JRSUIState> trackPainter = AquaPainter.create(JRSUIStateFactory.getSliderTrack());
    final AquaPainter<JRSUIState> thumbPainter = AquaPainter.create(JRSUIStateFactory.getSliderThumb());
    protected Color tickColor;
    protected Color disabledTickColor;
    protected transient boolean fIsDragging = false;
    static final int kTickWidth = 3;
    static final int kTickLength = 8;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSliderUI((JSlider)jComponent);
    }

    public AquaSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.FALSE);
        this.tickColor = UIManager.getColor("Slider.tickColor");
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener();
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        AquaFocusHandler.install(jSlider);
        AquaUtilControlSize.addSizePropertyListener(jSlider);
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        AquaUtilControlSize.removeSizePropertyListener(jSlider);
        AquaFocusHandler.uninstall(jSlider);
        super.uninstallListeners(jSlider);
    }

    @Override
    public void applySizeFor(JComponent jComponent, JRSUIConstants.Size size) {
        ((JRSUIState)this.thumbPainter.state).set(size);
        ((JRSUIState)this.trackPainter.state).set(size);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Rectangle rectangle = graphics.getClipBounds();
        JRSUIConstants.Orientation orientation = this.slider.getOrientation() == 0 ? JRSUIConstants.Orientation.HORIZONTAL : JRSUIConstants.Orientation.VERTICAL;
        JRSUIConstants.State state = this.getState();
        if (this.slider.getPaintTrack()) {
            boolean bl = rectangle.intersects(this.trackRect);
            if (!bl) {
                this.calculateGeometry();
            }
            if (bl || rectangle.intersects(this.thumbRect)) {
                this.paintTrack(graphics, jComponent, orientation, state);
            }
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics, jComponent, orientation, state);
        }
    }

    public void paintTrack(Graphics graphics, JComponent jComponent, JRSUIConstants.Orientation orientation, JRSUIConstants.State state) {
        ((JRSUIState)this.trackPainter.state).set(orientation);
        ((JRSUIState)this.trackPainter.state).set(state);
        this.trackPainter.paint(graphics, jComponent, this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
    }

    public void paintThumb(Graphics graphics, JComponent jComponent, JRSUIConstants.Orientation orientation, JRSUIConstants.State state) {
        ((JRSUIState)this.thumbPainter.state).set(orientation);
        ((JRSUIState)this.thumbPainter.state).set(state);
        ((JRSUIState)this.thumbPainter.state).set(this.slider.hasFocus() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        ((JRSUIState)this.thumbPainter.state).set(this.getDirection(orientation));
        this.thumbPainter.paint(graphics, jComponent, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
    }

    JRSUIConstants.Direction getDirection(JRSUIConstants.Orientation orientation) {
        if (this.shouldUseArrowThumb()) {
            return orientation == JRSUIConstants.Orientation.HORIZONTAL ? JRSUIConstants.Direction.DOWN : JRSUIConstants.Direction.RIGHT;
        }
        return JRSUIConstants.Direction.NONE;
    }

    JRSUIConstants.State getState() {
        if (!this.slider.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (this.fIsDragging) {
            return JRSUIConstants.State.PRESSED;
        }
        if (!AquaFocusHandler.isActive(this.slider)) {
            return JRSUIConstants.State.INACTIVE;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    public void paintTicks(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = AquaUtils.beginFont(graphics2D);
        if (this.slider.isEnabled()) {
            graphics.setColor(this.tickColor);
        } else {
            if (this.disabledTickColor == null) {
                this.disabledTickColor = new Color(this.tickColor.getRed(), this.tickColor.getGreen(), this.tickColor.getBlue(), this.tickColor.getAlpha() / 2);
            }
            graphics.setColor(this.disabledTickColor);
        }
        super.paintTicks(graphics);
        AquaUtils.endFont(graphics2D, object);
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.shouldUseArrowThumb()) {
            boolean bl = this.slider.getOrientation() == 0;
            JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(this.slider);
            if (size == JRSUIConstants.Size.REGULAR) {
                if (bl) {
                    this.thumbRect.y += 3;
                } else {
                    this.thumbRect.x += 2;
                }
                return;
            }
            if (size == JRSUIConstants.Size.SMALL) {
                if (bl) {
                    this.thumbRect.y += 2;
                } else {
                    this.thumbRect.x += 2;
                }
                return;
            }
            if (size == JRSUIConstants.Size.MINI) {
                if (bl) {
                    ++this.thumbRect.y;
                }
                return;
            }
        }
    }

    @Override
    protected void calculateThumbSize() {
        AquaUtilControlSize.SizeDescriptor sizeDescriptor = this.shouldUseArrowThumb() ? pointingThumbDescriptor.get() : roundThumbDescriptor.get();
        AquaUtilControlSize.SizeVariant sizeVariant = sizeDescriptor.get(this.slider);
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.setSize(sizeVariant.w, sizeVariant.h);
        } else {
            this.thumbRect.setSize(sizeVariant.h, sizeVariant.w);
        }
    }

    protected boolean shouldUseArrowThumb() {
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            return true;
        }
        Object object = this.slider.getClientProperty("Slider.paintThumbArrowShape");
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    @Override
    protected void calculateTickRect() {
        int n;
        int n2 = n = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        if (this.slider.getOrientation() == 0) {
            this.tickRect.height = n;
            this.tickRect.x = this.trackRect.x + this.trackBuffer;
            this.tickRect.y = this.trackRect.y + this.trackRect.height - this.tickRect.height / 2;
            this.tickRect.width = this.trackRect.width - this.trackBuffer * 2;
        } else {
            this.tickRect.width = n;
            this.tickRect.x = this.trackRect.x + this.trackRect.width - this.tickRect.width / 2;
            this.tickRect.y = this.trackRect.y + this.trackBuffer;
            this.tickRect.height = this.trackRect.height - this.trackBuffer * 2;
        }
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return MAC_PREFERRED_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return MAC_PREFERRED_VERTICAL_SIZE;
    }

    @Override
    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AquaSliderUI.this.fIsDragging) {
                    return;
                }
                AquaSliderUI.this.calculateThumbLocation();
                AquaSliderUI.this.slider.repaint();
            }
        };
    }

    int getScale() {
        if (!this.slider.getSnapToTicks()) {
            return 1;
        }
        int n = this.slider.getMinorTickSpacing();
        if (n < 1) {
            n = this.slider.getMajorTickSpacing();
        }
        if (n < 1) {
            return 1;
        }
        return n;
    }

    class TrackListener
    extends BasicSliderUI.TrackListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        TrackListener() {
            super(AquaSliderUI.this);
            this.currentMouseX = -1;
            this.currentMouseY = -1;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = -1;
            this.currentMouseY = -1;
            this.offset = 0;
            AquaSliderUI.this.scrollTimer.stop();
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.fIsDragging = false;
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                AquaSliderUI.this.fIsDragging = false;
            }
            AquaSliderUI.this.slider.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            boolean bl = this.currentMouseX == -1 && this.currentMouseY == -1;
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (AquaSliderUI.this.slider.isRequestFocusEnabled()) {
                AquaSliderUI.this.slider.requestFocus();
            }
            boolean bl2 = AquaSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY);
            if (!bl || !bl2) {
                AquaSliderUI.this.slider.setValueIsAdjusting(true);
                switch (AquaSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForYPosition(this.currentMouseY));
                        break;
                    }
                    case 0: {
                        AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForXPosition(this.currentMouseX));
                    }
                }
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                bl2 = true;
            }
            if (bl2) {
                switch (AquaSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((AquaSliderUI)AquaSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((AquaSliderUI)AquaSliderUI.this).thumbRect.x;
                    }
                }
                AquaSliderUI.this.fIsDragging = true;
                return;
            }
            AquaSliderUI.this.fIsDragging = false;
        }

        @Override
        public boolean shouldScroll(int n) {
            Rectangle rectangle = AquaSliderUI.this.thumbRect;
            if (AquaSliderUI.this.slider.getOrientation() == 1 ? ((AquaSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.y + rectangle.height <= this.currentMouseY : rectangle.y >= this.currentMouseY) : ((AquaSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.x + rectangle.width >= this.currentMouseX : rectangle.x <= this.currentMouseX)) {
                return false;
            }
            if (n > 0 && AquaSliderUI.this.slider.getValue() + AquaSliderUI.this.slider.getExtent() >= AquaSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return n >= 0 || AquaSliderUI.this.slider.getValue() > AquaSliderUI.this.slider.getMinimum();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = 0;
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!AquaSliderUI.this.fIsDragging) {
                return;
            }
            AquaSliderUI.this.slider.setValueIsAdjusting(true);
            switch (AquaSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((AquaSliderUI)AquaSliderUI.this).thumbRect.height / 2;
                    int n3 = mouseEvent.getY() - this.offset;
                    int n4 = ((AquaSliderUI)AquaSliderUI.this).trackRect.y;
                    int n5 = ((AquaSliderUI)AquaSliderUI.this).trackRect.y + (((AquaSliderUI)AquaSliderUI.this).trackRect.height - 1);
                    int n6 = AquaSliderUI.this.yPositionForValue(AquaSliderUI.this.slider.getMaximum() - AquaSliderUI.this.slider.getExtent());
                    if (AquaSliderUI.this.drawInverted()) {
                        n5 = n6;
                    } else {
                        n4 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    AquaSliderUI.this.setThumbLocation(((AquaSliderUI)AquaSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n7 = ((AquaSliderUI)AquaSliderUI.this).thumbRect.width / 2;
                    int n8 = mouseEvent.getX() - this.offset;
                    int n9 = ((AquaSliderUI)AquaSliderUI.this).trackRect.x;
                    int n10 = ((AquaSliderUI)AquaSliderUI.this).trackRect.x + (((AquaSliderUI)AquaSliderUI.this).trackRect.width - 1);
                    int n11 = AquaSliderUI.this.xPositionForValue(AquaSliderUI.this.slider.getMaximum() - AquaSliderUI.this.slider.getExtent());
                    if (AquaSliderUI.this.drawInverted()) {
                        n9 = n11;
                    } else {
                        n10 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    AquaSliderUI.this.setThumbLocation(n8, ((AquaSliderUI)AquaSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    AquaSliderUI.this.slider.setValue(AquaSliderUI.this.valueForXPosition(n));
                    break;
                }
                default: {
                    return;
                }
            }
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.calculateThumbLocation();
                AquaSliderUI.this.setThumbLocation(((AquaSliderUI)AquaSliderUI.this).thumbRect.x, ((AquaSliderUI)AquaSliderUI.this).thumbRect.y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

