/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaComboBoxUI;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

class AquaComboBoxPopup
extends BasicComboPopup {
    static final Insets FOCUS_RING_INSETS = new Insets(5, 6, 5, 6);
    protected Component topStrut;
    protected Component bottomStrut;
    protected boolean isPopDown = false;

    public AquaComboBoxPopup(JComboBox jComboBox) {
        super(jComboBox);
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.setBorderPainted(false);
        this.setBorder(null);
        this.updateContents(false);
        this.putClientProperty("apple.awt._windowFadeOut", new Integer(150));
    }

    public void updateContents(boolean bl) {
        this.isPopDown = this.isPopdown();
        if (this.isPopDown) {
            if (bl) {
                if (this.topStrut != null) {
                    this.remove(this.topStrut);
                }
                if (this.bottomStrut != null) {
                    this.remove(this.bottomStrut);
                }
            } else {
                this.add(this.scroller);
            }
        } else {
            if (this.topStrut == null) {
                this.topStrut = Box.createVerticalStrut(4);
                this.bottomStrut = Box.createVerticalStrut(4);
            }
            if (bl) {
                this.remove(this.scroller);
            }
            this.add(this.topStrut);
            this.add(this.scroller);
            this.add(this.bottomStrut);
        }
    }

    protected Dimension getBestPopupSizeForRowCount(int n) {
        int n2 = this.comboBox.getModel().getSize();
        int n3 = Math.min(n, n2);
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        for (int i = 0; i < n3; ++i) {
            Object e = this.list.getModel().getElementAt(i);
            Component component = listCellRenderer.getListCellRendererComponent(this.list, e, i, false, false);
            Dimension dimension2 = component.getPreferredSize();
            dimension.height += dimension2.height;
            dimension.width = Math.max(dimension2.width, dimension.width);
        }
        dimension.width += 10;
        return dimension;
    }

    protected boolean shouldScroll() {
        return this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
    }

    protected boolean isPopdown() {
        return this.shouldScroll() || AquaComboBoxUI.isPopdown(this.comboBox);
    }

    @Override
    public void show() {
        int n = this.comboBox.getItemCount();
        Rectangle rectangle = this.adjustPopupAndGetBounds();
        if (rectangle == null) {
            return;
        }
        this.show(this.comboBox, rectangle.x, rectangle.y);
        int n2 = this.comboBox.getItemCount();
        if (n2 == 0) {
            this.hide();
            return;
        }
        if (n != n2) {
            Rectangle rectangle2 = this.adjustPopupAndGetBounds();
            this.list.setSize(rectangle2.width, rectangle2.height);
            this.pack();
            Point point = this.comboBox.getLocationOnScreen();
            this.setLocation(point.x + rectangle2.x, point.y + rectangle2.y);
        }
        this.list.requestFocusInWindow();
    }

    protected JList createList() {
        return new JList(this.comboBox.getModel()){

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isMetaDown()) {
                    mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ 4, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                }
                super.processMouseEvent(mouseEvent);
            }
        };
    }

    protected Rectangle adjustPopupAndGetBounds() {
        if (this.isPopDown != this.isPopdown()) {
            this.updateContents(true);
        }
        Dimension dimension = this.getBestPopupSizeForRowCount(this.comboBox.getMaximumRowCount());
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        if (rectangle == null) {
            return null;
        }
        Dimension dimension2 = rectangle.getSize();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        this.list.invalidate();
        int n = this.comboBox.getSelectedIndex();
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
        }
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        return rectangle;
    }

    Rectangle getBestScreenBounds(Point point) {
        Rectangle rectangle;
        GraphicsConfiguration[] graphicsConfigurationArray;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle2 = this.comboBox.getBounds();
        if (graphicsDeviceArray.length == 1) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x + rectangle2.width < 0 || point.y + rectangle2.height < 0 || point.x > dimension.width || point.y > dimension.height) {
                return null;
            }
            return new Rectangle(0, 22, dimension.width, dimension.height - 22);
        }
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurationArray = graphicsDevice.getConfigurations()) {
                rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.contains(point)) continue;
                return rectangle;
            }
        }
        rectangle2.setLocation(point);
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurationArray = graphicsDevice.getConfigurations()) {
                rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.intersects(rectangle2)) continue;
                return rectangle;
            }
        }
        return null;
    }

    @Override
    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        int n5 = this.comboBox.getModel().getSize();
        boolean bl = this.isPopdown();
        boolean bl2 = AquaComboBoxUI.isTableCellEditor(this.comboBox);
        if (bl && !bl2) {
            n2 = Math.min(n2 / 2 + 9, n2);
        }
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.comboBox);
        Rectangle rectangle = this.getBestScreenBounds(point);
        if (rectangle == null) {
            return super.computePopupBounds(n, n2, n3, n4);
        }
        Insets insets = this.comboBox.getInsets();
        Rectangle rectangle2 = this.comboBox.getBounds();
        if (this.shouldScroll()) {
            n3 += 15;
        }
        if (bl) {
            n3 += 4;
        }
        int n6 = rectangle2.width - (insets.left + insets.right);
        n3 = Math.max(n6, n3);
        boolean bl3 = AquaUtils.isLeftToRight(this.comboBox);
        if (bl3) {
            n += insets.left;
            if (!this.isPopDown) {
                n -= AquaComboBoxPopup.FOCUS_RING_INSETS.left;
            }
        } else {
            n = rectangle2.width - n3 - insets.right;
            if (!this.isPopDown) {
                n += AquaComboBoxPopup.FOCUS_RING_INSETS.right;
            }
        }
        point.x += n;
        point.y += (n2 -= insets.bottom);
        if (point.x < rectangle.x) {
            n -= point.x + rectangle.x;
        }
        if (point.y < rectangle.y) {
            n2 -= point.y + rectangle.y;
        }
        Point point2 = new Point(0, 0);
        SwingUtilities.convertPointFromScreen(point2, this.comboBox);
        int n7 = Math.min(rectangle.width, point2.x + rectangle.x + rectangle.width) - 2;
        n3 = Math.min(n7, n3);
        if (n3 < n6) {
            n -= n6 - n3;
            n3 = n6;
        }
        if (!bl) {
            return this.computePopupBoundsForMenu(n, n2, n3 -= 6, n4, n5, rectangle);
        }
        if (!bl2) {
            n3 -= AquaComboBoxPopup.FOCUS_RING_INSETS.left + AquaComboBoxPopup.FOCUS_RING_INSETS.right;
            if (bl3) {
                n += AquaComboBoxPopup.FOCUS_RING_INSETS.left;
            }
        }
        Rectangle rectangle3 = new Rectangle(n, n2, n3, n4);
        if (rectangle3.y + rectangle3.height < point2.y + rectangle.y + rectangle.height) {
            return rectangle3;
        }
        return new Rectangle(n, -rectangle3.height + insets.top, rectangle3.width, rectangle3.height);
    }

    protected Rectangle computePopupBoundsForMenu(int n, int n2, int n3, int n4, int n5, Rectangle rectangle) {
        boolean bl;
        int n6;
        Rectangle rectangle2;
        int n7 = 0;
        if (this.list != null && n5 > 0 && (rectangle2 = this.list.getCellBounds(0, 0)) != null) {
            n7 = rectangle2.height;
        }
        if ((n6 = this.comboBox.getSelectedIndex()) < 0) {
            n6 = 0;
        }
        this.list.setSelectedIndex(n6);
        int n8 = n7 * n6;
        Point point = new Point(0, rectangle.y);
        Point point2 = new Point(0, rectangle.y + rectangle.height - 20);
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        SwingUtilities.convertPointFromScreen(point2, this.comboBox);
        Rectangle rectangle3 = new Rectangle(n, n2, n3, n4);
        int n9 = n4 - n8;
        boolean bl2 = n8 > -point.y;
        boolean bl3 = bl = n9 > point2.y;
        if (bl2) {
            rectangle3.y = point.y + 1;
            rectangle3.y = rectangle3.y / n7 * n7;
        } else {
            rectangle3.y = bl ? point2.y - rectangle3.height : -n8;
        }
        int n10 = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int n11 = n10 - (insets.top + insets.bottom);
        int n12 = (n11 - n7) / 2 + insets.top;
        rectangle3.y += n12 - AquaComboBoxPopup.FOCUS_RING_INSETS.bottom;
        return rectangle3;
    }
}

