/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

public class StringUtil {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static NumberFormat SIMPLE_ORDINATE_FORMAT = new DecimalFormat("0.#");

    public static String[] split(String s, String separator) {
        int separatorlen = separator.length();
        ArrayList<String> tokenList = new ArrayList<String>();
        String tmpString = s;
        int pos = tmpString.indexOf(separator);
        while (pos >= 0) {
            String token = tmpString.substring(0, pos);
            tokenList.add(token);
            tmpString = tmpString.substring(pos + separatorlen);
            pos = tmpString.indexOf(separator);
        }
        if (tmpString.length() > 0) {
            tokenList.add(tmpString);
        }
        String[] res = new String[tokenList.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = (String)tokenList.get(i);
            ++i;
        }
        return res;
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static String getStackTrace(Throwable t, int depth) {
        String stackTrace = "";
        StringReader stringReader = new StringReader(StringUtil.getStackTrace(t));
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        int i = 0;
        while (i < depth) {
            try {
                stackTrace = String.valueOf(stackTrace) + lineNumberReader.readLine() + NEWLINE;
            }
            catch (IOException e) {
                Assert.shouldNeverReachHere();
            }
            ++i;
        }
        return stackTrace;
    }

    public static String toString(double d) {
        return SIMPLE_ORDINATE_FORMAT.format(d);
    }

    public static String spaces(int n) {
        return StringUtil.chars(' ', n);
    }

    public static String chars(char c, int n) {
        char[] ch = new char[n];
        int i = 0;
        while (i < n) {
            ch[i] = c;
            ++i;
        }
        return new String(ch);
    }
}

