/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;

public class IDREFDatatypeValidator
extends AbstractDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private Hashtable fTableOfId = null;
    private Hashtable fTableIDRefs = null;
    private Object fNullValue = null;
    private Locale fLocale = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    public static final int IDREF_STORE = 0;
    public static final int IDREF_CLEAR = 1;
    public static final int IDREF_VALIDATE = 2;

    public IDREFDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDREFDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (object != null) {
            StateMessageDatatype stateMessageDatatype = (StateMessageDatatype)object;
            if (stateMessageDatatype.getDatatypeState() == 1) {
                if (this.fTableOfId != null) {
                    this.fTableOfId.clear();
                }
                if (this.fTableIDRefs != null) {
                    this.fTableIDRefs.clear();
                }
                return null;
            }
            if (stateMessageDatatype.getDatatypeState() == 2) {
                this.checkIdRefs();
            } else if (stateMessageDatatype.getDatatypeState() == 0) {
                this.fTableOfId = (Hashtable)stateMessageDatatype.getDatatypeObject();
                if (!XMLCharacterProperties.validName(string)) {
                    InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("IDREF is not valid");
                    invalidDatatypeValueException.setMinorCode(77);
                    invalidDatatypeValueException.setMajorCode(2);
                    throw invalidDatatypeValueException;
                }
                this.addIdRef(string, object);
            }
        }
        return null;
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    private void addIdRef(String string, Object object) {
        if (this.fTableOfId != null && this.fTableOfId.containsKey(string)) {
            return;
        }
        if (this.fTableIDRefs == null) {
            this.fTableIDRefs = new Hashtable();
        } else if (this.fTableIDRefs.containsKey(string)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        try {
            this.fTableIDRefs.put(string, this.fNullValue);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of Memory: Hashtable of ID's has " + this.fTableIDRefs.size() + " Elements");
            outOfMemoryError.printStackTrace();
        }
    }

    private void checkIdRefs() throws InvalidDatatypeValueException {
        if (this.fTableIDRefs == null) {
            return;
        }
        Enumeration enumeration = this.fTableIDRefs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.fTableOfId != null && this.fTableOfId.containsKey(string)) continue;
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string);
            invalidDatatypeValueException.setMinorCode(81);
            invalidDatatypeValueException.setMajorCode(2);
            throw invalidDatatypeValueException;
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }
}

