/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnHeaderRenderer;

public class JXTableHeader
extends JTableHeader {
    private MouseInputListener headerListener;

    public JXTableHeader() {
    }

    public JXTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        if (this.getXTable() != null) {
            this.installHeaderListener();
        } else {
            this.uninstallHeaderListener();
        }
    }

    public JXTable getXTable() {
        if (!(this.getTable() instanceof JXTable)) {
            return null;
        }
        return (JXTable)this.getTable();
    }

    public void updateUI() {
        super.updateUI();
        if (this.getDefaultRenderer() instanceof JComponent) {
            ((JComponent)((Object)this.getDefaultRenderer())).updateUI();
        }
    }

    private int getViewIndexForColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            return -1;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    protected TableCellRenderer createDefaultRenderer() {
        return ColumnHeaderRenderer.createColumnHeaderRenderer();
    }

    protected void installHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = new HeaderListener();
            this.addMouseListener(this.headerListener);
            this.addMouseMotionListener(this.headerListener);
        }
    }

    protected void uninstallHeaderListener() {
        if (this.headerListener != null) {
            this.removeMouseListener(this.headerListener);
            this.removeMouseMotionListener(this.headerListener);
            this.headerListener = null;
        }
    }

    private class HeaderListener
    implements MouseInputListener {
        private TableColumn cachedResizingColumn;

        private HeaderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            if (this.isInResizeRegion(mouseEvent)) {
                this.doResize(mouseEvent);
            } else {
                this.doSort(mouseEvent);
            }
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return !SwingUtilities.isLeftMouseButton(mouseEvent) || !JXTableHeader.this.table.isEnabled();
        }

        private void doSort(MouseEvent mouseEvent) {
            JXTable jXTable = JXTableHeader.this.getXTable();
            if (!jXTable.isSortable() || mouseEvent.getClickCount() != 1) {
                return;
            }
            if ((mouseEvent.getModifiersEx() & 0x40) == 64) {
                jXTable.resetSorter();
            } else {
                int n = JXTableHeader.this.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0) {
                    jXTable.setSorter(n);
                }
                this.uncacheResizingColumn();
            }
            JXTableHeader.this.repaint();
        }

        private void doResize(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            int n = JXTableHeader.this.getViewIndexForColumn(this.cachedResizingColumn);
            if (n >= 0) {
                JXTableHeader.this.getXTable().packColumn(n, 5);
            }
            this.uncacheResizingColumn();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.cacheResizingColumn(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.cacheResizingColumn(mouseEvent);
        }

        private void cacheResizingColumn(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 1) {
                return;
            }
            TableColumn tableColumn = JXTableHeader.this.getResizingColumn();
            if (tableColumn != null) {
                this.cachedResizingColumn = tableColumn;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent mouseEvent) {
            return this.cachedResizingColumn != null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.uncacheResizingColumn();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.uncacheResizingColumn();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

